/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.server.gds.mixvel.DataListsIndex;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel._1_01.AmountType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.BaggageAllowanceRefType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.EligibilityFlightAssociationsType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.FareComponentType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.FareDetailType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OrderItemType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OrderServiceType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OrderType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaxSegmentRefType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ServiceAssociationsType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ServiceDefinitionAssociationType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ServiceDefinitionType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.TaxSummaryType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.TaxType;
import https.www_mixvel_com.api.xsd.mixvel_orderviewrs._1_01.MixvelOrderViewRS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class MixvelOrderViewRSUpdatePricingProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MixvelOrderViewRS mixvelOrderViewRS = (MixvelOrderViewRS)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE);
        DataListsIndex index = new DataListsIndex(mixvelOrderViewRS.getResponse().getDataLists());
        OrderType order = (OrderType)CollectionUtil.single((Collection)mixvelOrderViewRS.getResponse().getMixOrder().getOrder());
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        for (Product product : AirProductHelper.getAirProductsList((Reservation)reservation)) {
            OrderItemType orderItem = MixvelOrderViewRSUpdatePricingProcessor.getOrderItemForProduct(order.getOrderItem(), product);
            product.getFares().clear();
            product.getTaxes().clear();
            Iterator stIter = product.getSegmentTariffs().iterator();
            FareDetailType fareDetail = (FareDetailType)CollectionUtil.single((Collection)orderItem.getFareDetail());
            for (FareComponentType fareComponent : fareDetail.getFareComponent()) {
                SegmentTariff st = (SegmentTariff)stIter.next();
                Iterator segIter = st.getSegments().iterator();
                for (String paxSegmentRefId : fareComponent.getPaxSegmentRefID()) {
                    Segment seg = (Segment)segIter.next();
                    seg.setServiceClass(MixvelHelper.getClassOfService(fareComponent.getCabinType().getCabinTypeCode()));
                    seg.setFareBasis(fareComponent.getFareBasisCode());
                    Set<String> baggageAllowanceRefIds = orderItem.getService().stream().filter(service -> product.getTravellerGdsId().equals(service.getPaxRefID().getValue())).map(OrderServiceType::getServiceAssociations).filter(Objects::nonNull).map(ServiceAssociationsType::getServiceDefinitionRef).filter(Objects::nonNull).filter(serviceDef -> Optional.ofNullable(serviceDef.getServiceDefinitionRefFlightAssociations()).map(EligibilityFlightAssociationsType::getPaxSegmentRef).map(PaxSegmentRefType::getPaxSegmentRefID).map(l -> l.contains(paxSegmentRefId)).orElse(false)).map(serviceDef -> index.getServiceDefinition(serviceDef.getServiceDefinitionRefID())).map(ServiceDefinitionType::getServiceDefinitionAssociation).filter(Objects::nonNull).map(ServiceDefinitionAssociationType::getBaggageAllowanceRef).filter(Objects::nonNull).map(BaggageAllowanceRefType::getBaggageAllowanceRefID).collect(Collectors.toSet());
                    seg.setLuggageInfo(MixvelHelper.buildLuggageInfo(index, baggageAllowanceRefIds));
                    seg.setFareDetails(MixvelHelper.buildFareDetails(index, baggageAllowanceRefIds, fareComponent));
                }
                ProductFare pf = new ProductFare();
                pf.setBaseFare(MixvelHelper.parseAmount(fareComponent.getPrice().getBaseAmount()));
                if (fareComponent.getPrice().getEquivAmount() != null) {
                    pf.setEquivalentFare(fareComponent.getPrice().getEquivAmount().getValue());
                } else {
                    pf.setEquivalentFare(fareComponent.getPrice().getBaseAmount().getValue());
                }
                String fareCurrency = pf.getBaseFare().getCurrency();
                BigDecimal addFareBaseAmount = BigDecimal.ZERO;
                ArrayList<String> taxCodes = new ArrayList<String>();
                ArrayList<String> taxCurrencies = new ArrayList<String>();
                if (fareComponent.getPrice().getTaxSummary() != null) {
                    Tax tax;
                    if (fareComponent.getPrice().getTaxSummary().getTax() != null) {
                        for (TaxType taxType : fareComponent.getPrice().getTaxSummary().getTax()) {
                            if (taxType.getTaxCode().length() == 1) {
                                BigDecimal amount = taxType.getAmount().getValue();
                                pf.setEquivalentFare(pf.getEquivalentFare().add(amount));
                                if (fareCurrency.equals(taxType.getAmount().getCurCode())) {
                                    addFareBaseAmount = addFareBaseAmount.add(amount);
                                    continue;
                                }
                                taxCodes.add(taxType.getTaxCode());
                                taxCurrencies.add(taxType.getAmount().getCurCode());
                                continue;
                            }
                            tax = MixvelOrderViewRSUpdatePricingProcessor.createTax(taxType.getTaxCode(), taxType.getAmount());
                            tax.setSegmentTariff(st);
                            product.getTaxes().add(tax);
                        }
                    } else {
                        AmountType totalTaxAmount;
                        TaxSummaryType taxSummary = fareComponent.getPrice().getTaxSummary();
                        if (taxSummary != null && (totalTaxAmount = taxSummary.getTotalTaxAmount()) != null) {
                            tax = MixvelOrderViewRSUpdatePricingProcessor.createTax("XT", fareComponent.getPrice().getTaxSummary().getTotalTaxAmount());
                            tax.setSegmentTariff(st);
                            product.getTaxes().add(tax);
                        }
                    }
                }
                if (!taxCurrencies.isEmpty()) {
                    pf.setBaseFare(null);
                    ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)L10nResourcesManager.getStr((String)"BASE_FARE_WAS_NOT_SET", (Object[])new Object[]{fareCurrency, String.join((CharSequence)", ", taxCodes), String.join((CharSequence)", ", taxCurrencies)}), (Object[])new Object[0]));
                } else {
                    pf.getBaseFare().setValue(pf.getBaseFare().getValue().add(addFareBaseAmount));
                }
                pf.setSegmentTariff(st);
                product.getFares().add(pf);
            }
        }
    }

    private static OrderItemType getOrderItemForProduct(List<OrderItemType> orderItems, Product product) {
        if (product.getGdsId() != null) {
            return (OrderItemType)Streams.single(orderItems.stream().filter(item -> product.getGdsId().equals(item.getOrderItemID())));
        }
        return (OrderItemType)Streams.single(orderItems.stream().filter(orderItem -> ((FareDetailType)CollectionUtil.single((Collection)orderItem.getFareDetail())).getPaxRefID().contains(product.getTravellerGdsId())).filter(orderItem -> ((FareDetailType)CollectionUtil.single((Collection)orderItem.getFareDetail())).getFareComponent().stream().map(FareComponentType::getPaxSegmentRefID).flatMap(Collection::stream).collect(Collectors.toList()).equals(AirProductHelper.getProductSegmentsStream((Product)product).map(Segment::getGdsId).collect(Collectors.toList()))));
    }

    private static Tax createTax(String taxCode, AmountType amountType) {
        Tax tax = new Tax();
        tax.setEquivalentAmount(amountType.getValue());
        tax.setCode(taxCode);
        tax.setAmount(MixvelHelper.parseAmount(amountType));
        return tax;
    }
}

