/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.gdsNameInfo;

import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.RecordLocatorInfo;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationGdsNameInfo;
import com.gridnine.xtrip.common.model.booking.ReservationSystemInfo;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.mixvel.MixvelGdsAccount;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;

public class MixvelReservationGdsNameInfoTest
extends ModelTestBase {
    protected void configureMetaregistry(MetaRegistry metaRegistry) throws Exception {
        super.configureMetaregistry(metaRegistry);
        metaRegistry.register(Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource("com/gridnine/xtrip/common/midoffice/model-basic-midoffice.xml")));
    }

    @Test
    public void testGdsNameInfo() throws Exception {
        MixvelGdsAccount gdsAccount = new MixvelGdsAccount();
        gdsAccount.setGds(GdsName.MIXVEL);
        EntityStorage.get().save(EntityContainer.create((BaseEntity)gdsAccount, (String)"fa859f00-8f4a-4132-8308-4a3eb9da2b2f"), true);
        Reservation reservation = (Reservation)this.loadXSerializable("MixvelReservationGdsNameInfoRenamerTest_RESERVATION.xml", Reservation.class);
        ReservationGdsNameInfo gdsNameInfo = reservation.getGdsNameInfo();
        Assert.assertEquals((Object)"fa859f00-8f4a-4132-8308-4a3eb9da2b2f", (Object)gdsNameInfo.getOnlineGdsAccount().getUid());
        Assert.assertEquals((Object)GdsName.MIXVEL, (Object)gdsNameInfo.getRulesGdsName());
        Assert.assertEquals((Object)GdsName.SIRENA, (Object)gdsNameInfo.getStatisticsGdsName());
        Assert.assertEquals((long)2L, (long)gdsNameInfo.getSystemInfos().size());
        block8: for (ReservationSystemInfo systemInfo : gdsNameInfo.getSystemInfos()) {
            switch (systemInfo.getGdsName()) {
                case MIXVEL: {
                    Assert.assertEquals((long)2L, (long)systemInfo.getRecordLocators().size());
                    block9: for (RecordLocatorInfo recordLocator : systemInfo.getRecordLocators()) {
                        switch (recordLocator.getType()) {
                            case MIXVEL_MIX_ORDER_ID: {
                                Assert.assertEquals((Object)"01138-240807-MOT5906", (Object)recordLocator.getRecordLocator());
                                Assert.assertFalse((boolean)recordLocator.isDisplay());
                                continue block9;
                            }
                            case MIXVEL_ORDER_ID: {
                                Assert.assertEquals((Object)"01138-240807-OOT5907", (Object)recordLocator.getRecordLocator());
                                Assert.assertFalse((boolean)recordLocator.isDisplay());
                                continue block9;
                            }
                        }
                        Assert.fail();
                    }
                    Assert.assertNull((Object)systemInfo.getBookingAgentDutyCode());
                    Assert.assertNull((Object)systemInfo.getBookingPcc());
                    continue block8;
                }
                case SIRENA: {
                    Assert.assertEquals((long)1L, (long)systemInfo.getRecordLocators().size());
                    RecordLocatorInfo recordLocatorInfo = (RecordLocatorInfo)systemInfo.getRecordLocators().get(0);
                    Assert.assertEquals((Object)"25LNG5", (Object)recordLocatorInfo.getRecordLocator());
                    Assert.assertTrue((boolean)recordLocatorInfo.isDisplay());
                    Assert.assertEquals((Object)"A12", (Object)systemInfo.getBookingAgentDutyCode());
                    Assert.assertEquals((Object)"ABCD", (Object)systemInfo.getBookingPcc());
                    continue block8;
                }
            }
            Assert.fail();
        }
        Assert.assertEquals((Object)"01138-240807-MOT5906", (Object)MixvelHelper.getMixOrderId(reservation));
        Assert.assertEquals((Object)"01138-240807-OOT5907", (Object)MixvelHelper.getOrderId(reservation));
    }
}

