/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.getFareRules;

import com.gridnine.xtrip.common.gds.model.FareRuleParagraph;
import com.gridnine.xtrip.common.model.gds.mixvel.MixvelRemarksSearchContext;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaxSegmentType;
import https.www_mixvel_com.api.xsd.mixvel_orderrulesrs._1_00.FareRuleTextType;
import https.www_mixvel_com.api.xsd.mixvel_orderrulesrs._1_00.MixvelOrderRulesRS;
import https.www_mixvel_com.api.xsd.mixvel_orderrulesrs._1_00.RemarkType;
import https.www_mixvel_com.api.xsd.mixvel_orderrulesrs._1_00.RulesType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MixvelOrderRulesRSParser
extends BaseProcessor {
    private static final Pattern fareRemarkTitleSplitPattern = Pattern.compile("^<b>(\\d+)\\. *(.*)</b>$", 8);

    public void process(MessageContext ctx) throws Exception {
        MixvelOrderRulesRS mixvelOrderRulesRS = (MixvelOrderRulesRS)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE);
        String frsc = (String)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FARE_REMARKS_SEARCH_CONTEXT);
        MixvelRemarksSearchContext context = new MixvelRemarksSearchContext();
        XUtil.fromString((String)frsc, (XSerializable)context);
        String paxSegmentID = ((PaxSegmentType)mixvelOrderRulesRS.getResponse().getDataLists().getPaxSegmentList().getPaxSegment().get(context.getSegmentIndex())).getPaxSegmentID();
        List frps = mixvelOrderRulesRS.getResponse().getRules().stream().filter(rules -> rules.getPaxSegmentRefID().contains(paxSegmentID)).map(RulesType::getFareRuleText).map(FareRuleTextType::getRemark).map(RemarkType::getRemarkText).flatMap(Collection::stream).map(MixvelOrderRulesRSParser::buildFareRuleParagraphs).flatMap(Collection::stream).collect(Collectors.toList());
        ctx.putObject((Enum)IBusGdsContextKeys.FARE_RULES, frps);
    }

    private static List<FareRuleParagraph> buildFareRuleParagraphs(String remark) {
        ArrayList<FareRuleParagraph> rules = new ArrayList<FareRuleParagraph>();
        Matcher m = fareRemarkTitleSplitPattern.matcher(remark);
        if (m.find()) {
            boolean hasFoundNextPart;
            boolean firstMatch = true;
            do {
                FareRuleParagraph frp;
                String text;
                String numberStr = m.group(1);
                String titleStr = m.group(2);
                int textStartPos = m.end();
                if (firstMatch && m.start() > 0 && TextUtil.nonBlank((String)(text = remark.substring(0, m.start()).trim()))) {
                    frp = new FareRuleParagraph();
                    frp.setContent(text);
                    rules.add(frp);
                }
                String textStr = (hasFoundNextPart = m.find()) ? remark.substring(textStartPos, m.start()) : remark.substring(textStartPos);
                frp = new FareRuleParagraph();
                frp.setTitle(titleStr);
                frp.setNumber(numberStr);
                frp.setContent(textStr);
                rules.add(frp);
                firstMatch = false;
            } while (hasFoundNextPart);
        } else {
            FareRuleParagraph frp = new FareRuleParagraph();
            frp.setContent(remark);
            rules.add(frp);
        }
        return rules;
    }
}

