/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.invoke;

import com.gridnine.xtrip.common.gds.exceptions.ReservationChangedInGdsException;
import com.gridnine.xtrip.common.gds.exceptions.SeatsNotConfirmedException;
import com.gridnine.xtrip.common.gds.mixvel.exceptions.NeedOrderRetrieveException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.ObjectTrace;
import com.gridnine.xtrip.server.gds.mixvel.model.AuthResponse;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ErrorType;
import https.www_mixvel_com.api.xsd.mixvel_airlineprofilers._1_01.MixvelAirlineProfileRS;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrs._1_00.MixvelAirShoppingRS;
import https.www_mixvel_com.api.xsd.mixvel_envelope._1_06.MixvelErrorCType;
import https.www_mixvel_com.api.xsd.mixvel_offerpricers._1_00.MixvelOfferPriceRS;
import https.www_mixvel_com.api.xsd.mixvel_ordercancelrs._1_00.MixvelOrderCancelRS;
import https.www_mixvel_com.api.xsd.mixvel_orderreshoprs._1_00.MixvelOrderReshopRS;
import https.www_mixvel_com.api.xsd.mixvel_orderrulesrs._1_00.MixvelOrderRulesRS;
import https.www_mixvel_com.api.xsd.mixvel_orderviewrs._1_01.MixvelOrderViewRS;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class MixvelErrorsTranslatorHelper {
    private static final Map<Pattern, String> MESSAGES = new HashMap<Pattern, String>();
    private static final Map<Pattern, Class<? extends Exception>> CUSTOM_EXCEPTIONS;

    public static void handleBodyError(MixvelErrorCType error) throws Exception {
        if (error == null) {
            return;
        }
        throw Xeption.forDeveloper((String)ObjectTrace.toString((Object)error), (Object[])new Object[0]);
    }

    public static void handleResponse(Object response) throws Exception {
        if (response instanceof AuthResponse) {
            MixvelErrorsTranslatorHelper.handleResponseError(((AuthResponse)((Object)response)).getError());
        } else if (response instanceof MixvelAirShoppingRS) {
            MixvelErrorsTranslatorHelper.handleResponseError(((MixvelAirShoppingRS)response).getError());
        } else if (response instanceof MixvelOfferPriceRS) {
            MixvelErrorsTranslatorHelper.handleResponseError(((MixvelOfferPriceRS)response).getError());
        } else if (response instanceof MixvelOrderViewRS) {
            MixvelErrorsTranslatorHelper.handleResponseError(((MixvelOrderViewRS)response).getError());
        } else if (response instanceof MixvelOrderRulesRS) {
            MixvelErrorsTranslatorHelper.handleResponseError(((MixvelOrderRulesRS)response).getError());
        } else if (response instanceof MixvelOrderCancelRS) {
            MixvelErrorsTranslatorHelper.handleResponseError(((MixvelOrderCancelRS)response).getError());
        } else if (response instanceof MixvelAirlineProfileRS) {
            MixvelErrorsTranslatorHelper.handleResponseError(((MixvelAirlineProfileRS)response).getError());
        } else if (response instanceof MixvelOrderReshopRS) {
            MixvelErrorsTranslatorHelper.handleResponseError(((MixvelOrderReshopRS)response).getError());
        } else {
            throw Xeption.forDeveloper((String)"unexpected response class {0}", (Object[])new Object[]{response.getClass().getName()});
        }
    }

    private static void handleResponseError(ErrorType error) throws Exception {
        if (error == null) {
            return;
        }
        if (error.getDescText().size() == 1) {
            String descText = (String)error.getDescText().get(0);
            for (Map.Entry<Pattern, Class<? extends Exception>> entry : CUSTOM_EXCEPTIONS.entrySet()) {
                if (error.getDescText().size() != 1 || !entry.getKey().matcher(descText).matches()) continue;
                throw entry.getValue().newInstance();
            }
            for (Map.Entry<Pattern, Object> entry : MESSAGES.entrySet()) {
                if (error.getDescText().size() != 1 || !entry.getKey().matcher(descText).matches()) continue;
                throw Xeption.forEndUser((String)((String)entry.getValue()), (Object[])new Object[0]);
            }
        }
        throw Xeption.forDeveloper((String)ObjectTrace.toString((Object)error), (Object[])new Object[0]);
    }

    static {
        MESSAGES.put(Pattern.compile("\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0435\u043c\u044b\u0435 \u0440\u0435\u0439\u0441\u044b \u0434\u043b\u044f OfferId [a-f\\d\\-]+ \u043d\u0435\u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\\. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0434\u0440\u0443\u0433\u043e\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435\\."), "OFFER_IS_NOT_VALID");
        MESSAGES.put(Pattern.compile("\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d. \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u043f\u043e\u043f\u044b\u0442\u043a\u0443 \u0447\u0435\u0440\u0435\u0437 \\d+ \u0441\u0435\u043a\u0443\u043d\u0434"), "GENERAL_ERROR");
        MESSAGES.put(Pattern.compile("\u041c\u0443\u043b\u044c\u0442\u0438\u043a\u043e\u0440\u0437\u0438\u043d\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0451\u043d\u043d\u044b\u0435 SSR \u0437\u0430\u043f\u0440\u043e\u0441\u044b.*"), "UNCONFIRMED_SSRS");
        MESSAGES.put(Pattern.compile("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u0443\u0436\u0435 \u0437\u0430\u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u044b: [a-f\\d\\-]+"), "OFFER_IS_NOT_VALID");
        CUSTOM_EXCEPTIONS = new HashMap<Pattern, Class<? extends Exception>>();
        CUSTOM_EXCEPTIONS.put(Pattern.compile("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0440\u0435\u0437\u0435\u0440\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043c\u0435\u0441\u0442\u0430 \u043d\u0430 \u0440\u0435\u0439\u0441\u0435 [A-Z0-9]{2}-\\d+. \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0434\u0440\u0443\u0433\u043e\u0439 \u0440\u0435\u0439\u0441 \\(\u041f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435\\(-\u044f\\): .*"), SeatsNotConfirmedException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile("[A-Z0-9]{2}: \u041f\u0420\u041e\u0414\u0410\u0416\u0410 \u0417\u0410\u041f\u0420\u0415\u0429\u0415\u041d\u0410.*\\(\u041f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435\\(-\u044f\\): .*", 32), SeatsNotConfirmedException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile("\u041f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \\([a-f\\d\\-]+\\) \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u0438\u043b\u0438 \u0441\u0440\u043e\u043a \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0438\u0441\u0442\u0435\u043a"), SeatsNotConfirmedException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(Pattern.quote("\u0417\u0430\u043a\u0430\u0437 \u0431\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d, \u0432\u043e\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0435\u0441\u044c \u043c\u0435\u0442\u043e\u0434\u043e\u043c OrderRetrieve \u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0440\u043e\u0441 \u0432 \u0441\u043b\u0443\u0447\u0430\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438")), NeedOrderRetrieveException.class);
        CUSTOM_EXCEPTIONS.put(Pattern.compile(Pattern.quote("\u0414\u0430\u043d\u043d\u044b\u0439 \u0437\u0430\u043a\u0430\u0437 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u0432 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0443, \u0447\u0442\u043e\u0431\u044b \u043f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f")), ReservationChangedInGdsException.class);
    }
}

