/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.invoke;

import com.gridnine.xtrip.common.midoffice.model.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.gds.mixvel.MixvelGdsAccount;
import com.gridnine.xtrip.common.model.system.HttpRequest;
import com.gridnine.xtrip.common.model.system.RequestMethod;
import com.gridnine.xtrip.common.util.UUIDUtil;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.invoke.MixvelJaxbContext;
import com.gridnine.xtrip.server.gds.mixvel.model.Auth;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jaxws.JaxWsHelper;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import https.www_mixvel_com.api.xsd.mixvel_envelope._1_06.Envelope;
import https.www_mixvel_com.api.xsd.mixvel_envelope._1_06.MixvelAppData;
import https.www_mixvel_com.api.xsd.mixvel_envelope._1_06.MixvelBodyCType;
import https.www_mixvel_com.api.xsd.mixvel_envelope._1_06.MixvelHeaderCType;
import https.www_mixvel_com.api.xsd.mixvel_envelope._1_06.MixvelMessageInfoCType;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.UUID;
import javax.xml.bind.Marshaller;

public class MixvelHttpRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Object request = ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_REQUEST);
        String endpoint = (String)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_ENDPOINT);
        Envelope envelope = MixvelHttpRequestBuilder.buildEnvelope(request);
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(((MixvelGdsAccount)gdsAccountCtr.getEntity()).getEndpointUrl().concat(endpoint));
        httpRequest.setUseSsl(true);
        httpRequest.setRequestMethod(RequestMethod.POST);
        if (!(request instanceof Auth)) {
            String token = (String)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_TOKEN);
            httpRequest.getRequestProperties().put((Object)"Authorization", (Object)"Bearer ".concat(token));
        }
        httpRequest.getRequestProperties().put((Object)"Content-Type", (Object)"application/xml");
        httpRequest.setBody(MixvelHttpRequestBuilder.marshal(envelope));
        ctx.putObject((Enum)IBusHttpContextKeys.HTTP_REQUEST, (Object)httpRequest);
    }

    private static Envelope buildEnvelope(Object request) {
        Envelope envelope = new Envelope();
        envelope.setHeader(new MixvelHeaderCType());
        MixvelBodyCType body = new MixvelBodyCType();
        MixvelMessageInfoCType messageInfo = new MixvelMessageInfoCType();
        messageInfo.setMessageId(UUIDUtil.toString((UUID)UUID.randomUUID()));
        messageInfo.setTimeSent(JaxWsHelper.toGregorianDate((Date)new Date()));
        body.setMessageInfo(messageInfo);
        MixvelAppData appData = new MixvelAppData();
        appData.setAny(request);
        body.setAppData(appData);
        envelope.setBody(body);
        return envelope;
    }

    private static byte[] marshal(Envelope envelope) throws Exception {
        Marshaller marshaller = MixvelJaxbContext.get().createMarshaller();
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            marshaller.marshal((Object)envelope, (OutputStream)stream);
            stream.flush();
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }
}

