/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.invoke;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.HttpResponse;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.invoke.MixvelErrorsTranslatorHelper;
import com.gridnine.xtrip.server.gds.mixvel.invoke.MixvelJaxbContext;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.http.IBusHttpContextKeys;
import https.www_mixvel_com.api.xsd.mixvel_envelope._1_06.Envelope;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.bind.Unmarshaller;

public class MixvelHttpResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        HttpResponse httpResponse = (HttpResponse)ctx.getMandatoryObject((Enum)IBusHttpContextKeys.HTTP_RESPONSE);
        if (httpResponse.getResponseCode() != 200) {
            throw Xeption.forDeveloper((String)("response code " + httpResponse.getResponseCode()), (Object[])new Object[0]);
        }
        Envelope envelope = MixvelHttpResponseParser.unmarshal(httpResponse.getBody());
        MixvelErrorsTranslatorHelper.handleBodyError(envelope.getBody().getError());
        Object response = envelope.getBody().getAppData().getAny();
        MixvelErrorsTranslatorHelper.handleResponse(response);
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE, response);
    }

    private static Envelope unmarshal(byte[] data) throws Exception {
        Unmarshaller unmarshaller = MixvelJaxbContext.get().createUnmarshaller();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(data);){
            Envelope envelope = (Envelope)unmarshaller.unmarshal((InputStream)stream);
            return envelope;
        }
    }
}

