/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.modifyFqtv;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.AirlineBonusCardParameters;
import com.gridnine.xtrip.common.gds.model.ModifyAirlineBonusCardsParameters;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.fqtv.IBusGdsFqtvContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel._1_01.CarrierType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.LoyaltyProgramActionTypeEnum;
import https.www_mixvel_com.api.xsd.mixvel._1_01.LoyaltyProgramType;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.DataListsType;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.LoyaltyProgramAccountChangeListType;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.LoyaltyProgramAccountChangeType;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.MixvelOrderChangeRQ;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.RequestType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MixvelOrderChangeRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ModifyAirlineBonusCardsParameters parameters = (ModifyAirlineBonusCardsParameters)ctx.getMandatoryObject((Enum)IBusGdsFqtvContextKeys.MODIFY_AIRLINE_BONUS_CARDS_PARAMETERS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List travellers = reservation.getBookingFile().getTravellers();
        Map<String, String> travellerUidToPaxId = AirProductHelper.getAirProductsStream((Reservation)reservation).map(p -> new MiscUtil.Pair((Object)p.getTraveller().getUid(), (Object)p.getTravellerGdsId())).distinct().collect(Collectors.toMap(MiscUtil.Pair::getFirst, MiscUtil.Pair::getSecond));
        List<String> paxSegmentRefIDs = this.getPaxSegmentRefIDs(reservation);
        MixvelOrderChangeRQ orderChangeRq = this.buildMixvelOrderChangeRQ(parameters, travellers, travellerUidToPaxId, paxSegmentRefIDs, MixvelHelper.getOrderId(reservation));
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_REQUEST, (Object)orderChangeRq);
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_ENDPOINT, (Object)"/api/Order/change");
    }

    private List<String> getPaxSegmentRefIDs(Reservation reservation) {
        return reservation.getProducts().stream().filter(bp -> bp instanceof Product).map(bp -> (Product)bp).flatMap(product -> product.getSegmentTariffs().stream()).flatMap(st -> st.getSegments().stream()).map(Segment::getGdsId).filter(TextUtil::nonBlank).collect(Collectors.toList());
    }

    private MixvelOrderChangeRQ buildMixvelOrderChangeRQ(ModifyAirlineBonusCardsParameters parameters, List<Traveller> travellers, Map<String, String> travellerUidToPaxId, List<String> paxSegmentRefIDs, String orderId) {
        MixvelOrderChangeRQ orderChangeRq = new MixvelOrderChangeRQ();
        RequestType request = new RequestType();
        DataListsType dataLists = new DataListsType();
        this.populateLoyalty(dataLists, parameters, travellers, travellerUidToPaxId, paxSegmentRefIDs, orderId);
        orderChangeRq.setRequest(request);
        return orderChangeRq;
    }

    private void populateLoyalty(DataListsType dataLists, ModifyAirlineBonusCardsParameters parameters, List<Traveller> travellers, Map<String, String> travellerUidToPaxId, List<String> paxSegmentRefIDs, String orderId) {
        if (!(parameters.getCardUidsToDelete().isEmpty() && parameters.getCardsToAdd().isEmpty() && parameters.getCardsToUpdate().isEmpty())) {
            dataLists.setLoyaltyProgramAccountList(new LoyaltyProgramAccountChangeListType());
            List loyalty = dataLists.getLoyaltyProgramAccountList().getLoyaltyProgramAccount();
            this.populateLoyaltyDelete(loyalty, parameters.getCardUidsToDelete(), travellers, travellerUidToPaxId, paxSegmentRefIDs, orderId);
            this.populateLoyaltyAdd(loyalty, parameters.getCardsToAdd(), travellers, travellerUidToPaxId, paxSegmentRefIDs, orderId);
            this.populateLoyaltyUpdate(loyalty, parameters.getCardsToUpdate(), travellers, travellerUidToPaxId, paxSegmentRefIDs, orderId);
        }
    }

    private void populateLoyaltyDelete(List<LoyaltyProgramAccountChangeType> loyalty, Set<String> cardsUidToDelete, List<Traveller> travellers, Map<String, String> travellerUidToPaxId, List<String> paxSegmentRefIDs, String orderId) {
        for (String cardUidToDelete : cardsUidToDelete) {
            for (Traveller traveller : travellers) {
                String paxId = travellerUidToPaxId.get(traveller.getUid());
                traveller.getAirlineBonusCards().stream().filter(travellerCard -> travellerCard.getUid().equals(cardUidToDelete)).map(card -> this.buildLoyaltyProgramAccount((BookingAirlineBonusCard)card, paxSegmentRefIDs, LoyaltyProgramActionTypeEnum.DELETE, paxId, orderId)).forEach(loyalty::add);
            }
        }
    }

    private void populateLoyaltyAdd(List<LoyaltyProgramAccountChangeType> loyalty, Set<AirlineBonusCardParameters> cardsToAdd, List<Traveller> travellers, Map<String, String> travellerUidToPaxId, List<String> paxSegmentRefIDs, String orderId) {
        for (AirlineBonusCardParameters cardToAdd : cardsToAdd) {
            for (Traveller traveller : travellers) {
                String paxId = travellerUidToPaxId.get(traveller.getUid());
                traveller.getAirlineBonusCards().stream().filter(travellerCard -> travellerCard.getUid().equals(cardToAdd.getCard().getUid())).map(card -> this.buildLoyaltyProgramAccount((BookingAirlineBonusCard)card, paxSegmentRefIDs, LoyaltyProgramActionTypeEnum.ADD, paxId, orderId)).forEach(loyalty::add);
            }
        }
    }

    private void populateLoyaltyUpdate(List<LoyaltyProgramAccountChangeType> loyalty, Set<BookingAirlineBonusCard> cardsToUpdate, List<Traveller> travellers, Map<String, String> travellerUidToPaxId, List<String> paxSegmentRefIDs, String orderId) {
        for (BookingAirlineBonusCard cardToUpdate : cardsToUpdate) {
            for (Traveller traveller : travellers) {
                String paxId = travellerUidToPaxId.get(traveller.getUid());
                traveller.getAirlineBonusCards().stream().filter(travellerCard -> travellerCard.getUid().equals(cardToUpdate.getUid())).forEach(travellerCard -> {
                    loyalty.add(this.buildLoyaltyProgramAccount((BookingAirlineBonusCard)travellerCard, paxSegmentRefIDs, LoyaltyProgramActionTypeEnum.DELETE, paxId, orderId));
                    loyalty.add(this.buildLoyaltyProgramAccount(cardToUpdate, paxSegmentRefIDs, LoyaltyProgramActionTypeEnum.ADD, paxId, orderId));
                });
            }
        }
    }

    private LoyaltyProgramAccountChangeType buildLoyaltyProgramAccount(BookingAirlineBonusCard airlineBonusCard, List<String> paxSegmentRefIDs, LoyaltyProgramActionTypeEnum value, String paxRefId, String orderId) {
        LoyaltyProgramAccountChangeType loyaltyProgramAccount = new LoyaltyProgramAccountChangeType();
        loyaltyProgramAccount.setAccountNumber(airlineBonusCard.getNumber());
        LoyaltyProgramType loyaltyProgram = new LoyaltyProgramType();
        CarrierType carrier = new CarrierType();
        carrier.setAirlineDesigCode(MixvelHelper.getNativeCode(airlineBonusCard.getAirline()));
        loyaltyProgram.setCarrier(carrier);
        loyaltyProgramAccount.setLoyaltyProgram(loyaltyProgram);
        loyaltyProgramAccount.getPaxSegmentRefID().addAll(paxSegmentRefIDs);
        loyaltyProgramAccount.setActionType(value);
        loyaltyProgramAccount.setPaxRefID(paxRefId);
        loyaltyProgramAccount.setOrderRefID(orderId);
        return loyaltyProgramAccount;
    }
}

