/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.refundReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefexFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetails;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel._1_01.AmountType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.FareComponentType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PriceType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.TaxType;
import https.www_mixvel_com.api.xsd.mixvel_orderreshoprs._1_00.DataListsType;
import https.www_mixvel_com.api.xsd.mixvel_orderreshoprs._1_00.ExistingOrderItemType;
import https.www_mixvel_com.api.xsd.mixvel_orderreshoprs._1_00.MixvelOrderReshopRS;
import https.www_mixvel_com.api.xsd.mixvel_orderreshoprs._1_00.OfferType;
import https.www_mixvel_com.api.xsd.mixvel_orderreshoprs._1_00.OrderItemDeletionOfferItemType;
import https.www_mixvel_com.api.xsd.mixvel_orderreshoprs._1_00.PenaltyType;
import https.www_mixvel_com.api.xsd.mixvel_orderreshoprs._1_00.ReshopOffersType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class FillUnsellFinanceDetailsWithGdsDetailsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map unsellRequest = (Map)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_REQUEST);
        UnsellFinanceDetails unsellFinanceDetails = (UnsellFinanceDetails)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_FINANCE_DETAILS);
        MixvelOrderReshopRS orderReshopRS = (MixvelOrderReshopRS)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE);
        List productsToRefund = AirProductHelper.getAirProductsStream((Reservation)reservation).filter(p -> unsellRequest.containsKey(p.getUid())).collect(Collectors.toList());
        ReshopOffersType reshopOffers = orderReshopRS.getResponse().getReshopResults().getReshopOffers();
        OfferType offer = (OfferType)CollectionUtil.single((Collection)reshopOffers.getOffer());
        List existingOrderItems = ((OrderItemDeletionOfferItemType)CollectionUtil.single((Collection)offer.getDeleteOrderItem())).getExistingOrderItem();
        DataListsType dataLists = orderReshopRS.getResponse().getDataLists();
        Map penalties = dataLists.getPenaltyList() != null ? dataLists.getPenaltyList().getPenalty().stream().collect(Collectors.toMap(PenaltyType::getPenaltyID, Function.identity())) : null;
        for (Product product : productsToRefund) {
            GdsProductRefexFinanceDetails gdsProductRefexFinanceDetails = (GdsProductRefexFinanceDetails)unsellFinanceDetails.getGdsDetails().get((Object)product.getUid());
            List<PriceType> prices = FillUnsellFinanceDetailsWithGdsDetailsProcessor.getExistingOrderItemForProduct(existingOrderItems, product).getPriceDifferential().getDiffPrice().getFareDetail().getFareComponent().stream().map(FareComponentType::getPrice).collect(Collectors.toList());
            Money baseFare = MoneyHelper.buildMoney((BigDecimal)this.countAmount(prices.stream().map(PriceType::getBaseAmount).collect(Collectors.toList())), (String)((PriceType)prices.get(0)).getBaseAmount().getCurCode());
            gdsProductRefexFinanceDetails.setBaseFare(baseFare);
            if (prices.stream().allMatch(p -> p.getEquivAmount() != null)) {
                BigDecimal equivFare = this.countAmount(prices.stream().map(PriceType::getEquivAmount).collect(Collectors.toList()));
                gdsProductRefexFinanceDetails.setEquivalentFare(equivFare);
            } else {
                gdsProductRefexFinanceDetails.setEquivalentFare(gdsProductRefexFinanceDetails.getBaseFare().getValue());
            }
            List<TaxType> taxList = this.getTaxList(prices);
            if (!taxList.isEmpty()) {
                for (TaxType tax : taxList) {
                    SimpleTax st = new SimpleTax();
                    st.setAmount(tax.getAmount().getValue());
                    st.setCode(tax.getTaxCode());
                    gdsProductRefexFinanceDetails.getTaxes().add(st);
                }
            }
            if (offer.getPenaltyRefID().isEmpty()) continue;
            gdsProductRefexFinanceDetails.setPenalty(offer.getPenaltyRefID().stream().map(penalties::get).map(PenaltyType::getPrice).map(PriceType::getBaseAmount).map(AmountType::getValue).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
    }

    private static ExistingOrderItemType getExistingOrderItemForProduct(List<ExistingOrderItemType> orderItems, Product product) {
        if (product.getGdsId() != null) {
            return (ExistingOrderItemType)Streams.single(orderItems.stream().filter(item -> product.getGdsId().equals(item.getOrderItemRefID())));
        }
        return (ExistingOrderItemType)Streams.single(orderItems.stream().filter(orderItem -> orderItem.getPriceDifferential().getDiffPrice().getFareDetail().getPaxRefID().contains(product.getTravellerGdsId())).filter(orderItem -> orderItem.getPriceDifferential().getDiffPrice().getFareDetail().getFareComponent().stream().map(FareComponentType::getPaxSegmentRefID).flatMap(Collection::stream).collect(Collectors.toList()).containsAll(AirProductHelper.getProductSegmentsStream((Product)product).map(Segment::getGdsId).collect(Collectors.toList()))));
    }

    private BigDecimal countAmount(List<AmountType> amounts) {
        return amounts.stream().map(AmountType::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private List<TaxType> getTaxList(List<PriceType> prices) {
        ArrayList<TaxType> taxList = new ArrayList<TaxType>();
        for (PriceType price : prices) {
            if (price.getTaxSummary() == null || price.getTaxSummary().getTax() == null) continue;
            taxList.addAll(price.getTaxSummary().getTax());
        }
        return taxList;
    }
}

