/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.gds.mixvel.BestPricingOptionText;
import com.gridnine.xtrip.common.model.gds.mixvel.MixvelGdsAccount;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelAirShoppingRQHelper;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.gds.mixvel.MixvelTripartiteContractHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jaxws.JaxWsHelper;
import https.www_mixvel_com.api.xsd.mixvel._1_01.BaggageFilterEnum;
import https.www_mixvel_com.api.xsd.mixvel._1_01.BaggagePricingCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.BestPricingOptionTextType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.CalendarDateCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.DestArrivalCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.FlightRequestOriginDestinationsCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OriginDepCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OriginDestCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PreferenceFilterRE;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PricingMethodCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ProgramAccountType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ProgramCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ShoppingCriteriaType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ShoppingRequestCabinTypeType;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrq._1_01.FlightRequestType;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrq._1_01.MixvelAirShoppingRQ;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrq._1_01.PaxsType;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrq._1_01.RequestType;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class MixvelAirShoppingRQBuilder
extends BaseProcessor {
    private static final DatatypeFactory DATATYPE_FACTORY;

    public void process(MessageContext ctx) {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        Set<DictionaryReference> applicableAirlines = (Set<DictionaryReference>)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.APPLICABLE_AIRLINES);
        Map accountCodes = (Map)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES_BY_AIRLINE);
        Integer matrixSize = (Integer)ctx.getObject((Enum)IBusGdsContextKeys.MATRIX_SIZE);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        MixvelAirShoppingRQ rq = new MixvelAirShoppingRQ();
        RequestType request = new RequestType();
        ShoppingCriteriaType shoppingCriteria = new ShoppingCriteriaType();
        MixvelAirShoppingRQHelper.CriteriaAccumulator criteriaAccumulator = new MixvelAirShoppingRQHelper.CriteriaAccumulator(shoppingCriteria);
        FlightRequestType flightRequest = new FlightRequestType();
        FlightRequestOriginDestinationsCriteriaType criterias = new FlightRequestOriginDestinationsCriteriaType();
        for (RouteSegment rs : fsp.getRoute()) {
            OriginDestCriteriaType criteria = new OriginDestCriteriaType();
            criteria.getCabinType().addAll(MixvelAirShoppingRQBuilder.buildCabinTypes(fsp.getServiceClass()));
            criteria.setConnectionPrefRefID(criteriaAccumulator.accumulateConnectionCriteria(fsp.isSkipConnected() || rs.getFlightNumber() != null));
            if (matrixSize != null) {
                CalendarDateCriteriaType calendarDateCriteria = new CalendarDateCriteriaType();
                calendarDateCriteria.setDaysAfterNumber(matrixSize.intValue());
                calendarDateCriteria.setDaysBeforeNumber(matrixSize.intValue());
                if (fsp.isSkipConnected()) {
                    calendarDateCriteria.setAllowDirectInd(Boolean.valueOf(true));
                }
                criteria.setCalendarDateCriteria(calendarDateCriteria);
            }
            DestArrivalCriteriaType destArrivalCriteria = new DestArrivalCriteriaType();
            destArrivalCriteria.setIATALocationCode(MixvelAirShoppingRQHelper.buildLocationCodeType((DictionaryReference<GeoLocation>)rs.getLocationEnd()));
            if (rs.getArrivalTimeBegin() != null) {
                destArrivalCriteria.setTimeRangeStart(MixvelAirShoppingRQBuilder.convertTime(rs.getArrivalTimeBegin()));
            }
            if (rs.getArrivalTimeEnd() != null) {
                destArrivalCriteria.setTimeRangeEnd(MixvelAirShoppingRQBuilder.convertTime(rs.getArrivalTimeEnd()));
            }
            criteria.setDestArrivalCriteria(destArrivalCriteria);
            OriginDepCriteriaType originDepCriteria = new OriginDepCriteriaType();
            originDepCriteria.setDate(JaxWsHelper.toGregorianLocalDate((Date)rs.getDate()));
            originDepCriteria.setIATALocationCode(MixvelAirShoppingRQHelper.buildLocationCodeType((DictionaryReference<GeoLocation>)rs.getLocationBegin()));
            if (rs.getDepartureTimeBegin() != null) {
                originDepCriteria.setTimeRangeStart(MixvelAirShoppingRQBuilder.convertTime(rs.getDepartureTimeBegin()));
            }
            if (rs.getDepartureTimeEnd() != null) {
                originDepCriteria.setTimeRangeEnd(MixvelAirShoppingRQBuilder.convertTime(rs.getDepartureTimeEnd()));
            }
            criteria.setOriginDepCriteria(originDepCriteria);
            if (!applicableAirlines.isEmpty() || rs.getAirline() != null) {
                criteria.getCarrierPrefRefID().add(criteriaAccumulator.accumulateCarrierCriteria((rs.getAirline() != null ? Collections.singleton(rs.getAirline()) : applicableAirlines).stream().map(MixvelHelper::getNativeCode).collect(Collectors.toSet()), rs.getFlightNumber()));
            }
            criterias.getOriginDestCriteria().add(criteria);
        }
        flightRequest.setFlightRequestOriginDestinationsCriteria(criterias);
        request.setFlightRequest(flightRequest);
        PaxsType paxs = new PaxsType();
        int id = 1;
        for (SeatPreferences sp : fsp.getSeats()) {
            for (int i = 0; i < sp.getCount(); ++i) {
                paxs.getPax().add(MixvelAirShoppingRQHelper.buildPax((DictionaryReference<PassengerType>)sp.getPassengerType(), id++));
            }
        }
        request.setPaxs(paxs);
        PricingMethodCriteriaType pricingMethodCriteria = new PricingMethodCriteriaType();
        if (((MixvelGdsAccount)gdsAccountCtr.getEntity()).getBestPricingOptionText() == BestPricingOptionText.EXTENDED) {
            pricingMethodCriteria.setBestPricingOptionText(BestPricingOptionTextType.EXTENDED);
        }
        pricingMethodCriteria.setCarrierMixInd(Boolean.valueOf(!fsp.isExcludeMultiTicket()));
        shoppingCriteria.setPricingMethodCriteria(pricingMethodCriteria);
        if (fsp.isExcludeBaglessFares()) {
            BaggagePricingCriteriaType baggagePricingCriteria = new BaggagePricingCriteriaType();
            baggagePricingCriteria.getBaggageOptionCode().add(BaggageFilterEnum.CHECKED_BAG);
            shoppingCriteria.setBaggagePricingCriteria(baggagePricingCriteria);
        }
        if (!accountCodes.isEmpty()) {
            for (Map.Entry accountCodeGroup : accountCodes.entrySet()) {
                for (String accountCode : (Collection)accountCodeGroup.getValue()) {
                    ProgramCriteriaType programCriteria = new ProgramCriteriaType();
                    programCriteria.setOwnerCode(MixvelHelper.getNativeCode((DictionaryReference)accountCodeGroup.getKey()));
                    ProgramAccountType programAccount = new ProgramAccountType();
                    programAccount.setAccountID(MixvelTripartiteContractHelper.buildAccountID(accountCode));
                    programCriteria.setProgramAccount(programAccount);
                    shoppingCriteria.getProgramCriteria().add(programCriteria);
                }
            }
        }
        shoppingCriteria.setFlightCriteria(MixvelAirShoppingRQHelper.buildFlightCriteria());
        request.setShoppingCriteria(shoppingCriteria);
        MixvelAirShoppingRQHelper.addPayloadRestrictions(request, (MixvelGdsAccount)gdsAccountCtr.getEntity(), fsp.getLimit());
        rq.setRequest(request);
        rq.setPayloadAttributes(MixvelAirShoppingRQHelper.buildPayloadAttributes((MixvelGdsAccount)gdsAccountCtr.getEntity()));
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_REQUEST, (Object)rq);
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_ENDPOINT, (Object)"/api/Order/airshopping");
    }

    private static XMLGregorianCalendar convertTime(int minutesAfterMidnight) {
        LocalTime time = LocalTime.MIDNIGHT.plusMinutes(minutesAfterMidnight);
        return DATATYPE_FACTORY.newXMLGregorianCalendar(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, time.getHour(), time.getMinute(), 0, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    private static List<ShoppingRequestCabinTypeType> buildCabinTypes(ClassOfService classOfService) {
        ArrayList<ShoppingRequestCabinTypeType> cabinTypesPrefLevel = new ArrayList<ShoppingRequestCabinTypeType>();
        if (ClassOfService.ECONOMY == classOfService) {
            cabinTypesPrefLevel.add(MixvelAirShoppingRQHelper.buildCabin("Business", PreferenceFilterRE.EXCLUDED));
            cabinTypesPrefLevel.add(MixvelAirShoppingRQHelper.buildCabin("First", PreferenceFilterRE.EXCLUDED));
            return cabinTypesPrefLevel;
        }
        if (ClassOfService.PREMIUM == classOfService) {
            cabinTypesPrefLevel.add(MixvelAirShoppingRQHelper.buildCabin("Premium Economy", PreferenceFilterRE.REQUIRED));
            return cabinTypesPrefLevel;
        }
        if (ClassOfService.BUSINESS == classOfService) {
            cabinTypesPrefLevel.add(MixvelAirShoppingRQHelper.buildCabin("Business", PreferenceFilterRE.REQUIRED));
            return cabinTypesPrefLevel;
        }
        if (ClassOfService.FIRST == classOfService) {
            cabinTypesPrefLevel.add(MixvelAirShoppingRQHelper.buildCabin("First", PreferenceFilterRE.REQUIRED));
            return cabinTypesPrefLevel;
        }
        throw Xeption.forDeveloper((String)"unsupported class of service {0}", (Object[])new Object[]{classOfService});
    }

    static {
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

