/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.searchFlights;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.DataListsIndex;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelCustomPropertiesHelper;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OfferType;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrs._1_00.DataListsType;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrs._1_00.MixvelAirShoppingRS;
import java.util.ArrayList;

public class MixvelAirShoppingRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        MixvelAirShoppingRS rs = (MixvelAirShoppingRS)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE);
        DataListsType dataLists = rs.getResponse().getDataLists();
        ArrayList<Flight> flights = new ArrayList<Flight>();
        if (dataLists != null) {
            DataListsIndex index = new DataListsIndex(dataLists);
            for (OfferType offer : rs.getResponse().getOffer()) {
                ArrayList<SeatPreferences> seats = new ArrayList<SeatPreferences>();
                for (SeatPreferences seat : fsp.getSeats()) {
                    SeatPreferences sp = new SeatPreferences();
                    sp.setPassengerType(MixvelHelper.resolvePassengerTypeCode(MixvelHelper.getPassengerTypeCode((DictionaryReference<PassengerType>)seat.getPassengerType())));
                    sp.setCount(seat.getCount());
                    seats.add(sp);
                }
                try {
                    Flight flight = MixvelHelper.convertOfferTypeToFlight(offer, index, seats);
                    MixvelCustomPropertiesHelper.setOfferId(flight, offer.getOfferID());
                    flights.add(flight);
                }
                catch (Exception ex) {
                    IncidentsLog.reportException((String)String.format("failed converting flight in MixVel (OfferID = %s)", offer.getOfferID()), (Throwable)ex);
                }
            }
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, flights);
    }
}

