/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.searchFlights;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.searchFlights.MixvelAirShoppingRSParser;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrs._1_00.MixvelAirShoppingRS;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.junit.Assert;
import org.junit.Test;

public class MixvelAirShoppingRSParserTest
extends ModelTestBase {
    @Test
    public void test() throws Exception {
        MessageContext ctx = new MessageContext();
        MixvelAirShoppingRS mixvelAirShoppingRS = this.readResponseFromFile(MixvelAirShoppingRS.class, "AirShoppingRS.xml");
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE, (Object)mixvelAirShoppingRS);
        FlightSearchParameters fsp = this.buildTstFlightSearchParameters();
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)fsp);
        MixvelAirShoppingRSParser parser = new MixvelAirShoppingRSParser();
        parser.process(ctx);
        Collection flights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        Assert.assertFalse((boolean)flights.isEmpty());
    }

    private <T> MixvelAirShoppingRS readResponseFromFile(Class<T> responseClass, String fileName) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((String)responseClass.getPackage().getName());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        InputStreamReader rdr = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(fileName));
        return (MixvelAirShoppingRS)unmarshaller.unmarshal((Reader)rdr);
    }

    private FlightSearchParameters buildTstFlightSearchParameters() {
        FlightSearchParameters fsp = new FlightSearchParameters();
        SeatPreferences sp1 = new SeatPreferences();
        sp1.setCount(2);
        sp1.setPassengerType(DictHelper.getAdultPassengerType());
        SeatPreferences sp2 = new SeatPreferences();
        sp2.setCount(1);
        sp2.setPassengerType(DictHelper.getInfantPassengerType());
        SeatPreferences sp3 = new SeatPreferences();
        sp3.setCount(1);
        sp3.setPassengerType(DictHelper.getChildPassengerType());
        fsp.getSeats().addAll(Arrays.asList(sp1, sp2, sp3));
        return fsp;
    }
}

