/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.searchSimpleMatrix;

import com.gridnine.xtrip.common.gds.model.SimpleMatrixElement;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrs._1_00.MixvelAirShoppingRS;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrs._1_00.PriceCalendarDateType;
import https.www_mixvel_com.api.xsd.mixvel_airshoppingrs._1_00.PriceCalendarType;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;

public class MixvelAirShoppingSimpleMatrixRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MixvelAirShoppingRS rs = (MixvelAirShoppingRS)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE);
        List simpleMatrix = rs.getResponse().getPriceCalendar().stream().map(this::buildSimpleMatrixElement).collect(Collectors.toList());
        ctx.putObject((Enum)IBusGdsContextKeys.SIMPLE_MATRIX, simpleMatrix);
    }

    private SimpleMatrixElement buildSimpleMatrixElement(PriceCalendarType calendar) {
        SimpleMatrixElement element = new SimpleMatrixElement();
        element.setBestPrice(MixvelHelper.parseAmount(calendar.getTotalPriceAmount()));
        List priceCalendarDate = calendar.getPriceCalendarDate();
        element.setDateFrom(MiscUtil.toLocalDate((Date)MiscUtil.toDateSafe((XMLGregorianCalendar)((PriceCalendarDateType)priceCalendarDate.get(0)).getDate())));
        if (priceCalendarDate.size() > 1) {
            element.setDateTo(MiscUtil.toLocalDate((Date)MiscUtil.toDateSafe((XMLGregorianCalendar)((PriceCalendarDateType)priceCalendarDate.get(1)).getDate())));
        }
        return element;
    }
}

