/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.selectFlight;

import com.gridnine.xtrip.common.gds.exceptions.SeatsNotConfirmedException;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.DataListsIndex;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelCustomPropertiesHelper;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OfferType;
import https.www_mixvel_com.api.xsd.mixvel_offerpricers._1_00.MixvelOfferPriceRS;
import https.www_mixvel_com.api.xsd.mixvel_offerpricers._1_00.ResponseType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MixvelOfferPriceRSParser
extends BaseProcessor {
    private boolean returnAllFares;

    public void configure(Map<String, String> parameters) {
        this.returnAllFares = Boolean.parseBoolean(parameters.get("return-all-fares"));
    }

    public void process(MessageContext ctx) throws Exception {
        MixvelOfferPriceRS mixvelOfferPriceRS = (MixvelOfferPriceRS)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE);
        ResponseType response = mixvelOfferPriceRS.getResponse();
        Flight selectedFlight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        DataListsIndex index = new DataListsIndex(response.getDataLists());
        OfferType pricedOffer = response.getPricedOffer();
        List otherOffers = response.getOtherOffers() != null ? response.getOtherOffers().getOffer() : new ArrayList();
        List aLaCarteOffers = response.getOtherOffers() != null ? response.getOtherOffers().getALaCarteOffer() : new ArrayList();
        Flight pricedFlight = null;
        if (pricedOffer != null) {
            pricedFlight = MixvelHelper.convertOfferTypeToFlight(pricedOffer, index, selectedFlight.getSeats());
            MixvelCustomPropertiesHelper.setOfferId(pricedFlight, pricedOffer.getOfferID());
        }
        if (this.returnAllFares) {
            ArrayList<Flight> flights = new ArrayList<Flight>();
            if (pricedFlight != null) {
                flights.add(pricedFlight);
            }
            if (!otherOffers.isEmpty()) {
                for (OfferType offerVariant : otherOffers) {
                    Flight flightVariant = MixvelHelper.convertOfferTypeToFlight(offerVariant, index, selectedFlight.getSeats());
                    MixvelCustomPropertiesHelper.setOfferId(flightVariant, offerVariant.getOfferID());
                    flights.add(flightVariant);
                }
            }
            ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, flights);
        } else {
            if (pricedFlight == null) {
                throw new SeatsNotConfirmedException();
            }
            ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT, (Object)pricedFlight);
        }
        if (!aLaCarteOffers.isEmpty()) {
            // empty if block
        }
    }
}

