/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.sendDocoDoca;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.gds.mixvel.createReservation.MixvelOrderCreateRQHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel._1_01.MixOrderRefType;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.DataListsType;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.MixvelOrderChangeRQ;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.PaxSegmentRemarkChangeListType;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.PaxSegmentRemarkChangeType;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.RemarkActionTypeEnum;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.RequestType;
import java.util.Collection;

public class MixvelDocoDocaRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        MixvelOrderChangeRQ mixvelOrderCreateRQ = new MixvelOrderChangeRQ();
        RequestType request = new RequestType();
        MixOrderRefType mixOrder = new MixOrderRefType();
        mixOrder.setMixOrderID(MixvelHelper.getMixOrderId(reservation));
        request.setMixOrder(mixOrder);
        DataListsType dataLists = new DataListsType();
        String orderId = MixvelHelper.getOrderId(reservation);
        int idx = 1;
        for (Traveller traveller : travellers) {
            String id = String.valueOf(idx);
            traveller.getDocoInformations().forEach(doco -> {
                PaxSegmentRemarkChangeType paxSegmentRemarkType = new PaxSegmentRemarkChangeType();
                PaxSegmentRemarkChangeListType paxSegmentRemarkListType = new PaxSegmentRemarkChangeListType();
                paxSegmentRemarkType.setOrderRefID(orderId);
                paxSegmentRemarkType.setPaxRefID("Pax-".concat(id));
                paxSegmentRemarkType.setType("doco");
                paxSegmentRemarkType.setText(MixvelOrderCreateRQHelper.buildDocoText(doco, false));
                paxSegmentRemarkType.setActionType(RemarkActionTypeEnum.ADD);
                paxSegmentRemarkListType.getPaxSegmentRemark().add(paxSegmentRemarkType);
                dataLists.setPaxSegmentRemarkList(paxSegmentRemarkListType);
            });
            traveller.getDocaInformations().forEach(doca -> {
                PaxSegmentRemarkChangeType paxSegmentRemarkType = new PaxSegmentRemarkChangeType();
                paxSegmentRemarkType.setOrderRefID(orderId);
                paxSegmentRemarkType.setPaxRefID("Pax-".concat(id));
                paxSegmentRemarkType.setType("doca");
                paxSegmentRemarkType.setText(MixvelOrderCreateRQHelper.buildDocaText(doca, false));
                paxSegmentRemarkType.setActionType(RemarkActionTypeEnum.ADD);
                dataLists.getPaxSegmentRemarkList().getPaxSegmentRemark().add(paxSegmentRemarkType);
            });
        }
        request.setDataLists(dataLists);
        mixvelOrderCreateRQ.setRequest(request);
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_REQUEST, (Object)mixvelOrderCreateRQ);
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_ENDPOINT, (Object)"/api/Order/change");
    }
}

