/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.splitReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel._1_01.BookingRefType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.MixOrderType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.OrderType;
import https.www_mixvel_com.api.xsd.mixvel_orderviewrs._1_01.MixvelOrderViewRS;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class MixvelOrderViewRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        MixvelOrderViewRS orderViewRS = (MixvelOrderViewRS)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE);
        MixOrderType mixOrder = orderViewRS.getResponse().getMixOrder();
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Reservation splitReservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SPLIT_RESERVATION);
        List splitReservationPaxIDs = AirProductHelper.getAirProductsStream((Reservation)splitReservation).map(Product::getTravellerGdsId).collect(Collectors.toList());
        String orderId = MixvelHelper.getOrderId(reservation);
        OrderType splitOrder = (OrderType)Streams.single(mixOrder.getOrder().stream().filter(order -> !order.getOrderID().equals(orderId)).filter(order -> order.getOrderItem().stream().flatMap(oi -> oi.getFareDetail().stream()).flatMap(fd -> fd.getPaxRefID().stream()).anyMatch(splitReservationPaxIDs::contains)));
        for (BookingRefType bookingRef : splitOrder.getBookingRef()) {
            if (!Objects.nonNull(bookingRef.getBookingEntity()) || !MixvelHelper.SIRENA_CODES.contains(bookingRef.getBookingEntity().getCarrier().getAirlineDesigCode())) continue;
            CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)splitReservation, (GdsName)GdsName.SIRENA, (RecordLocatorType)RecordLocatorType.SIRENA_LATIN, (String)bookingRef.getBookingID());
        }
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)splitReservation, (GdsName)GdsName.MIXVEL, (RecordLocatorType)RecordLocatorType.MIXVEL_ORDER_ID, (String)splitOrder.getOrderID());
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)splitReservation, (GdsName)GdsName.MIXVEL, (RecordLocatorType)RecordLocatorType.MIXVEL_MIX_ORDER_ID, (String)mixOrder.getMixOrderID());
    }
}

