/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.gds.mixvel.MixvelHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import https.www_mixvel_com.api.xsd.mixvel._1_01.AmountType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.DirectBillType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.MixOrderRefType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaymentProcessingDetailsPaymentMethodType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.PaymentProcessingDetailsType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ResponseParametersChangeRequestType;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.MixvelOrderChangeRQ;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.PaymentFunctionsChangeType;
import https.www_mixvel_com.api.xsd.mixvel_orderchangerq._1_00.RequestType;
import java.math.BigDecimal;

public class MixvelOrderChangeRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Fop fop = (Fop)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.FOP);
        MixvelOrderChangeRQ orderChangeRQ = new MixvelOrderChangeRQ();
        RequestType request = new RequestType();
        MixOrderRefType mixOrder = new MixOrderRefType();
        mixOrder.setMixOrderID(MixvelHelper.getMixOrderId(reservation));
        request.setMixOrder(mixOrder);
        PaymentFunctionsChangeType paymentFunctions = new PaymentFunctionsChangeType();
        PaymentProcessingDetailsType paymentProcessingDetails = new PaymentProcessingDetailsType();
        AmountType amount = new AmountType();
        amount.setCurCode((String)Streams.single(AirProductHelper.getAirProductsStream((Reservation)reservation).map(Product::getGdsCurrency).distinct()));
        amount.setValue(AirProductHelper.getAirProductsStream((Reservation)reservation).map(AirProductHelper::getTotalEquivalentFare).reduce(BigDecimal.ZERO, BigDecimal::add));
        paymentProcessingDetails.setAmount(amount);
        PaymentProcessingDetailsPaymentMethodType paymentProcessingDetailsPaymentMethod = new PaymentProcessingDetailsPaymentMethodType();
        if (fop.getType() == PaymentType.CASH) {
            paymentProcessingDetailsPaymentMethod.setOtherPaymentMethod(new https.www_mixvel_com.api.xsd.mixvel._1_01.PaymentType());
        } else {
            DirectBillType directBill = new DirectBillType();
            directBill.setBillInfo(".");
            paymentProcessingDetailsPaymentMethod.setDirectBill(directBill);
        }
        paymentProcessingDetails.setPaymentProcessingDetailsPaymentMethod(paymentProcessingDetailsPaymentMethod);
        paymentFunctions.getPaymentProcessingDetails().add(paymentProcessingDetails);
        request.setPaymentFunctions(paymentFunctions);
        ResponseParametersChangeRequestType responseParameters = new ResponseParametersChangeRequestType();
        responseParameters.setShowItinReceipt(Boolean.TRUE);
        request.setResponseParameters(responseParameters);
        orderChangeRQ.setRequest(request);
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_REQUEST, (Object)orderChangeRQ);
        ctx.putObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_ENDPOINT, (Object)"/api/Order/change");
    }
}

