/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.mixvel.ticketReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.Streams;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.mixvel.IBusGdsMixvelContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ElectronicTicketFormType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.FileDescType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.ItinTypeLineType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.TicketDocInfoType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.TicketReceiptDataType;
import https.www_mixvel_com.api.xsd.mixvel._1_01.TicketType;
import https.www_mixvel_com.api.xsd.mixvel_orderviewrs._1_01.MixvelOrderViewRS;
import java.net.URL;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

public class MixvelOrderViewRSUpdateReservationAfterTicketingProcessor
extends BaseProcessor {
    private static final DateTimeFormatter DTF_RU = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("ddMMMyy").toFormatter(new Locale("ru"));
    private static final DateTimeFormatter DTF_EN = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("ddMMMyy").toFormatter(Locale.ENGLISH);

    public void process(MessageContext ctx) throws Exception {
        MixvelOrderViewRS orderViewRS = (MixvelOrderViewRS)ctx.getMandatoryObject((Enum)IBusGdsMixvelContextKeys.MIXVEL_RESPONSE);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        EntityContainer bfCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        for (TicketDocInfoType ticketDocInfo : orderViewRS.getResponse().getTicketDocInfo()) {
            for (TicketType ticket : ticketDocInfo.getTicket()) {
                List taxSummaryType;
                List endorsementsRestrictions;
                ElectronicTicketFormType electronicTicketForm;
                Product product;
                List products = AirProductHelper.getAirProductsStream((Reservation)reservation).filter(p -> p.getTravellerGdsId().equals(ticketDocInfo.getPaxRefID())).collect(Collectors.toList());
                if (products.size() > 1) {
                    List paxSegmentRefIDs = ticket.getCoupon().stream().flatMap(coupon -> coupon.getSoldAirlineInfo().getPaxSegmentRefID().stream()).collect(Collectors.toList());
                    product = (Product)Streams.single(products.stream().filter(p -> AirProductHelper.getSegments((Collection)p.getSegmentTariffs()).stream().map(Segment::getGdsId).anyMatch(paxSegmentRefIDs::contains)));
                } else {
                    product = (Product)products.get(0);
                }
                String ticketNumber = ticket.getTicketNumber();
                if (TextUtil.isBlank((String)product.getSystemNumber())) {
                    if (TextUtil.isBlank((String)ticketNumber)) {
                        throw Xeption.forDeveloper((String)"no ticket number for gds id {0}", (Object[])new Object[]{ticketDocInfo.getPaxRefID()});
                    }
                    product.setCarrierNumber(ticketNumber.substring(0, 3));
                    product.setSystemNumber(ticketNumber.substring(3));
                }
                List segmentIDs = AirProductHelper.getSegments((Collection)product.getSegmentTariffs()).stream().map(Segment::getGdsId).collect(Collectors.toList());
                List tickets = ticketDocInfo.getTicket().stream().filter(tt -> tt.getCoupon().stream().anyMatch(couponType -> segmentIDs.stream().anyMatch(couponType.getSoldAirlineInfo().getPaxSegmentRefID()::contains))).collect(Collectors.toList());
                product.setConjCount(tickets.size() - 1);
                Iterator segmentIterator = AirProductHelper.getSegments((Collection)product.getSegmentTariffs()).iterator();
                TicketReceiptDataType ticketReceiptData = ticket.getTicketReceiptData();
                if (ticketReceiptData == null || (electronicTicketForm = ticketReceiptData.getElectronicTicketForm()) == null) continue;
                if (product.getEndorsement() == null && (endorsementsRestrictions = electronicTicketForm.getEndorsementsRestrictions()) != null && !endorsementsRestrictions.isEmpty()) {
                    product.setEndorsement(String.join((CharSequence)"", endorsementsRestrictions));
                }
                if (product.getFareCalculationData() == null && (taxSummaryType = electronicTicketForm.getTaxSummaryType()) != null && !taxSummaryType.isEmpty()) {
                    product.setFareCalculationData(String.join((CharSequence)"", taxSummaryType));
                }
                for (ItinTypeLineType itineraryType : electronicTicketForm.getItineraryType()) {
                    String maxVis;
                    if (!segmentIterator.hasNext()) continue;
                    Segment segment = (Segment)segmentIterator.next();
                    String minVis = itineraryType.getMinVis();
                    if (TextUtil.nonBlank((String)minVis)) {
                        segment.setNotValidBefore(this.getDate(minVis));
                    }
                    if (!TextUtil.nonBlank((String)(maxVis = itineraryType.getMaxVis()))) continue;
                    segment.setNotValidAfter(this.getDate(maxVis));
                }
            }
        }
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        if (((Organization)EntityStorage.get().resolve(salesContext.getSubagency()).getEntity()).isSirenaItinReceipts()) {
            try {
                Set urls = orderViewRS.getResponse().getTicketDocInfo().stream().map(TicketDocInfoType::getTicket).flatMap(Collection::stream).map(TicketType::getTicketReceipt).map(FileDescType::getURL).collect(Collectors.toSet());
                int number = urls.size();
                for (String url : urls) {
                    --number;
                    byte[] pdfContent = IOUtils.toByteArray((URL)new URL(url));
                    Document doc = new Document();
                    doc.setType(DocumentType.SPECIAL_TRAVELDOCUMENT);
                    doc.setContent(pdfContent);
                    doc.setContentType(ContentType.PDF);
                    doc.setCreated(new Date());
                    boolean isSeveralTravellers = ((BookingFile)bfCtr.getEntity()).getTravellers().size() > 1;
                    boolean isContainingEMD = GDSHelper.getMcoProductsStream((Collection)reservation.getProducts()).findAny().isPresent();
                    MixvelOrderViewRSUpdateReservationAfterTicketingProcessor.setNameAndTitle(doc, isSeveralTravellers, isContainingEMD, number);
                    doc.setNavigationKey(reservation.getUid());
                    doc.setOwner(bfCtr.toReference());
                    HashSet<Document> documents = (HashSet<Document>)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS);
                    if (documents == null) {
                        documents = new HashSet<Document>();
                        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS, documents);
                    }
                    documents.add(doc);
                }
            }
            catch (Exception ex) {
                SysLogHelper.audit((EntityReference)bfCtr.toReference(), (String)"tch-itinerary-receipt", (Message[])new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)L10nResourcesManager.getStr((String)"TCH_ITINERARY_ERROR", (Object[])new Object[0]), (Throwable)ex, (Object[])new Object[0])});
            }
        }
    }

    private static void setNameAndTitle(Document doc, boolean isSeveralTravellers, boolean isContainingEMD, int number) {
        String travelDoc = "\u041c\u0430\u0440\u0448\u0440\u0443\u0442\u043d\u0430\u044f \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u044f";
        String travelDocs = "\u041c\u0430\u0440\u0448\u0440\u0443\u0442\u043d\u044b\u0435 \u043a\u0432\u0438\u0442\u0430\u043d\u0446\u0438\u0438";
        String emd = " \u0438 \u042d\u041c\u0414";
        String forAllPassengers = " \u0434\u043b\u044f \u0432\u0441\u0435\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432";
        String pdf = ".pdf";
        if (isSeveralTravellers) {
            if (isContainingEMD) {
                doc.setTitle(travelDocs + emd + forAllPassengers + pdf);
                doc.setName(travelDocs + emd + forAllPassengers + pdf);
            } else {
                doc.setTitle(travelDocs + forAllPassengers + pdf);
                doc.setName(travelDocs + forAllPassengers + pdf);
            }
        } else if (isContainingEMD) {
            doc.setTitle(travelDoc + emd + pdf);
            doc.setName(travelDoc + emd + pdf);
        } else {
            doc.setTitle(travelDoc + pdf);
            doc.setName(travelDoc + pdf);
        }
        if (number > 0) {
            doc.setTitle(number + "_" + doc.getTitle());
            doc.setName(number + "_" + doc.getName());
        }
    }

    private Date getDate(String data) {
        char c = data.charAt(2);
        DateTimeFormatter dtf = c >= 'A' && c <= 'Z' ? DTF_EN : DTF_RU;
        return Date.from(LocalDate.parse(data.contains("\u041c\u0410\u0419") ? data.replace("\u041c\u0410\u0419", "\u041c\u0410\u042f") : data, dtf).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }
}

