/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.midoffice.helper.ReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.standard.helpers.NamedValueHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.s7ndc.SegmentWrapper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirlineIDType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.BookingReferenceType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.CodesetType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.DataListObjAttrGroup;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareBasisCodeType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareComponentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareQualifierType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightArrivalType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightCOSCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightDepartureType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightNumber;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfFlightSegmentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfOfferInstructionsType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.MarketingCarrierFlightType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ObjectKeyMetaAttrGroup;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PenaltyType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.SegmentKey;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServiceFilterType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.SrvPriceReqParamsType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TicketDesignatorType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TicketDocument;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.FastDateFormat;

public class S7NDCHelper {
    private static final String S7_NDC_SERVICE_OSI_CODE = "s7ndcServiceOsiCode";
    private static final CodeTranslator IATA_CODE_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.IATA.name()});
    private static final CodeTranslator S7NDC_CODE_TRANSLATOR = new CodeTranslator(new String[]{CodeSystem.S7NDC.name()});
    private static FastDateFormat TIME_DF = FastDateFormat.getInstance((String)"HH:mm");
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String TIME_PATTERN = "HH:mm";
    public static final String S7_AIRLINE_ID = "S7";
    private static String FARE_BASIS_SEPARATOR = "/";

    public static <D extends BaseDictionary> String getIataNativeCode(DictionaryReference<D> ref) {
        return IATA_CODE_TRANSLATOR.getNativeCode(ref, false);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveIataNativeCode(Class<D> cls, String code) {
        return IATA_CODE_TRANSLATOR.resolveNativeCode(cls, code);
    }

    public static <D extends BaseDictionary> String getS7NDCNativeCode(DictionaryReference<D> ref) {
        return S7NDC_CODE_TRANSLATOR.getNativeCode(ref, false);
    }

    public static <D extends BaseDictionary> DictionaryReference<D> resolveS7NDCNativeCode(Class<D> cls, String code) {
        return S7NDC_CODE_TRANSLATOR.resolveNativeCode(cls, code);
    }

    public static ClassOfService getClassOfService(String classOfService) {
        switch (classOfService) {
            case "Y": {
                return ClassOfService.ECONOMY;
            }
            case "C": 
            case "B": {
                return ClassOfService.BUSINESS;
            }
        }
        throw Xeption.forDeveloper((String)"unexpected classOfService {0}", (Object[])new Object[]{classOfService});
    }

    public static String buildClassOfService(ClassOfService classOfService) {
        switch (classOfService) {
            case ECONOMY: {
                return "Y";
            }
            case BUSINESS: {
                return "D";
            }
        }
        throw Xeption.forDeveloper((String)"\u041d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 service class {0}", (Object[])new Object[]{classOfService.toString()});
    }

    public static java.util.Date buildDateTime(Date date, String time) throws ParseException {
        return new SimpleDateFormat(String.format("%s %s", DATE_PATTERN, TIME_PATTERN)).parse(String.format("%s %s", date.toString(), time != null ? time : "00:00"));
    }

    public static LocalDateTime buildLocalDateTime(Date date, String time) {
        if (date == null) {
            return null;
        }
        return LocalDateTime.of(date.toLocalDate(), LocalTime.parse(time != null ? time : "00:00"));
    }

    public static java.util.Date convertToDate(Date date) {
        if (date == null) {
            return null;
        }
        return new java.util.Date(date.getTime());
    }

    public static DictionaryReference<Airline> getS7AirlineReference() {
        return S7NDCHelper.resolveIataNativeCode(Airline.class, S7_AIRLINE_ID);
    }

    public static <T> boolean isValidS7TravellersSafe(Flight flight, Collection<? extends T> travellers, Function<? super T, DictionaryReference<PassengerType>> passengerTypeExtractor, Function<? super T, java.util.Date> birthDateExtractor) {
        if (Objects.isNull(flight) || Objects.isNull(travellers) || Objects.isNull(passengerTypeExtractor) || Objects.isNull(birthDateExtractor)) {
            return true;
        }
        Airline s7Airline = (Airline)DictionaryCache.get().resolveReference(S7NDCHelper.getS7AirlineReference());
        if (Objects.isNull(s7Airline)) {
            return true;
        }
        boolean s7AirlineContains = FlightHelper.segmentStreamSafe((Flight)flight).map(FlightSegment::getAirline).anyMatch(arg_0 -> ((AirlineReference)s7Airline.toReference()).equals(arg_0));
        if (!s7AirlineContains) {
            return true;
        }
        java.util.Date minAdultBirthDate = FlightHelper.segmentStreamSafe((Flight)flight).map(FlightSegment::getDateBegin).findAny().map(MiscUtil::clearTime).map(firstDepartureDate -> MiscUtil.addYearsToDate((java.util.Date)firstDepartureDate, (int)-18)).orElse(null);
        if (Objects.isNull(minAdultBirthDate)) {
            return true;
        }
        Map travellerMap = travellers.stream().filter(Objects::nonNull).map(traveller -> new MiscUtil.Pair(passengerTypeExtractor.apply(traveller), birthDateExtractor.apply(traveller))).filter(pair -> Objects.nonNull(pair.getFirst()) && Objects.nonNull(pair.getSecond())).collect(Collectors.groupingBy(MiscUtil.Pair::getFirst, Collectors.mapping(MiscUtil.Pair::getSecond, Collectors.minBy(java.util.Date::compareTo))));
        if (!travellerMap.containsKey(DictHelper.getChildPassengerType()) && !travellerMap.containsKey(DictHelper.getInfantPassengerType())) {
            return true;
        }
        return travellerMap.entrySet().stream().map(Map.Entry::getValue).filter(Optional::isPresent).map(Optional::get).anyMatch(birthDate -> minAdultBirthDate.compareTo((java.util.Date)birthDate) >= 0);
    }

    public static void setAncillaryFeeOsiCode(AncillaryFee af, String osiCode) {
        NamedValueHelper.setValueForName((String)S7_NDC_SERVICE_OSI_CODE, (String)osiCode, (Collection)af.getCustomProperties());
    }

    public static String getAncillaryFeeOsiCode(AncillaryFee af) {
        return NamedValueHelper.getValueForName((String)S7_NDC_SERVICE_OSI_CODE, (Collection)af.getCustomProperties());
    }

    public static FlightDepartureType buildFlightDepartureType(DictionaryReference<GeoLocation> locRef, java.util.Date date) {
        FlightDepartureType result = new FlightDepartureType();
        result.setAirportCodeString(S7NDCHelper.getIataNativeCode(locRef));
        result.setDate(new Date(date.getTime()));
        result.setTime1(TIME_DF.format(date));
        return result;
    }

    public static FlightArrivalType buildFlightArrivalType(DictionaryReference<GeoLocation> locRef, java.util.Date date) {
        FlightArrivalType result = new FlightArrivalType();
        result.setAirportCodeString(S7NDCHelper.getIataNativeCode(locRef));
        result.setDate(new Date(date.getTime()));
        result.setTime1(TIME_DF.format(date));
        return result;
    }

    public static MarketingCarrierFlightType buildMarketingCarrierFlightType(DictionaryReference<Airline> airlineRef, String flightNo) {
        MarketingCarrierFlightType result = new MarketingCarrierFlightType();
        AirlineIDType airlineId = new AirlineIDType();
        airlineId.setString(S7NDCHelper.getIataNativeCode(airlineRef));
        result.setAirlineID(airlineId);
        FlightNumber flightNumber = new FlightNumber();
        flightNumber.setString(flightNo);
        result.setFlightNumber(flightNumber);
        return result;
    }

    public static FlightType.Flight.OperatingCarrier buildFlightOperatingCarrier(FlightSegment flightSegment) {
        return S7NDCHelper.buildFlightOperatingCarrier((DictionaryReference<Airline>)flightSegment.getOperatingAirline(), flightSegment.getOperatingFlightNumber());
    }

    public static FlightType.Flight.OperatingCarrier buildFlightOperatingCarrier(Segment seg) {
        return S7NDCHelper.buildFlightOperatingCarrier((DictionaryReference<Airline>)seg.getCodeShareCarrier(), seg.getCodeShareFlightNo());
    }

    public static FlightType.Flight.OperatingCarrier buildFlightOperatingCarrier(DictionaryReference<Airline> airline, String flightNo) {
        FlightType.Flight.OperatingCarrier result = new FlightType.Flight.OperatingCarrier();
        AirlineIDType airlineId = new AirlineIDType();
        airlineId.setString(S7NDCHelper.getIataNativeCode(airline));
        result.setAirlineID(airlineId);
        if (flightNo != null) {
            FlightNumber flightNumber = new FlightNumber();
            flightNumber.setString(flightNo);
            result.setFlightNumber(flightNumber);
        }
        return result;
    }

    public static ListOfFlightSegmentType.OperatingCarrier buildOperatingCarrier(Segment seg) {
        ListOfFlightSegmentType.OperatingCarrier result = new ListOfFlightSegmentType.OperatingCarrier();
        AirlineIDType airlineId = new AirlineIDType();
        airlineId.setString(S7NDCHelper.getIataNativeCode(seg.getCodeShareCarrier()));
        result.setAirlineID(airlineId);
        if (seg.getCodeShareFlightNo() != null) {
            FlightNumber flightNumber = new FlightNumber();
            flightNumber.setString(seg.getCodeShareFlightNo());
            result.setFlightNumber(flightNumber);
        }
        return result;
    }

    public static Pair<String> getMcoOriginDestinationCodes(Product mcoProduct) {
        List segments = AirProductHelper.getSegments((Collection)mcoProduct.getSegmentTariffs());
        return S7NDCHelper.getMcoOriginDestinationCodes(segments);
    }

    public static Pair<String> getMcoOriginDestinationCodes(List<Segment> segments) {
        Segment firstSegment = segments.get(0);
        Segment lastSegment = segments.get(segments.size() - 1);
        return new Pair((Object)S7NDCHelper.getIataNativeCode(firstSegment.getDepartureLocation()), (Object)S7NDCHelper.getIataNativeCode(lastSegment.getArriveLocation()));
    }

    public static String getGdsTicketDocumentType(ProductCategory productCategory) {
        if (productCategory == ProductCategory.MCO) {
            return "Y";
        }
        return "702";
    }

    public static boolean isCorrectRemainingProducts(Collection<List<Product>> productGroupsAfterCancel) {
        if (CollectionUtil.isEmpty(productGroupsAfterCancel)) {
            return true;
        }
        for (List<Product> productGroup : productGroupsAfterCancel) {
            if (S7NDCHelper.isCorrectProductGroup(productGroup)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCorrectProductGroup(List<Product> products) {
        int countCorrectProducts = 0;
        Optional<Product> byPrevProduct = products.stream().filter(product -> ((AncillaryFeeDescription)DictionaryCache.get().resolveReference(product.getAncillaryFeeDescription())).getRequiredAncillaryFee() == null).findFirst();
        while (byPrevProduct.isPresent()) {
            ++countCorrectProducts;
            Optional<Product> tmpByProduct = byPrevProduct;
            Optional<Product> byRequiredForPrevProduct = products.stream().filter(product -> {
                DictionaryReference requiredAncillaryFee = ((AncillaryFeeDescription)DictionaryCache.get().resolveReference(product.getAncillaryFeeDescription())).getRequiredAncillaryFee();
                return MiscUtil.equals((Object)requiredAncillaryFee, (Object)((Product)tmpByProduct.get()).getAncillaryFeeDescription());
            }).findFirst();
            byPrevProduct = byRequiredForPrevProduct;
        }
        return countCorrectProducts == products.size();
    }

    public static BookingReferenceType buildGdsBookingReference(Reservation reservation) {
        return S7NDCHelper.buildGdsBookingReference(S7NDCHelper.getRecordLocator(reservation));
    }

    public static BookingReferenceType buildGdsBookingReference(String recordLocator) {
        BookingReferenceType result = new BookingReferenceType();
        result.setID(recordLocator);
        AirlineIDType airlineIDAirlineIDType = new AirlineIDType();
        airlineIDAirlineIDType.setString(S7_AIRLINE_ID);
        result.setAirlineIDAirlineIDType(airlineIDAirlineIDType);
        return result;
    }

    public static String extractProductSystemNumber(TicketDocument ticketDocument) {
        return S7NDCHelper.extractProductSystemNumber(ticketDocument.getTicketDocNbr());
    }

    public static String extractProductSystemNumber(String gdsTicketDocNbr) {
        return gdsTicketDocNbr.substring(3);
    }

    public static String buildFareBasis(FareComponentType fct) {
        String fareBasisCode = fct.getFareBasis().getFareBasisCode().getCode();
        TicketDesignatorType ticketDesig = fct.getTicketDesig();
        if (ticketDesig == null) {
            return fareBasisCode;
        }
        return TextUtil.concat((String[])new String[]{fareBasisCode, FARE_BASIS_SEPARATOR, ticketDesig.getApplication(), ticketDesig.getString()});
    }

    public static String extractFareBasisCode(String fareBasis) {
        String[] parts = fareBasis.split(FARE_BASIS_SEPARATOR);
        return parts[0];
    }

    public static boolean flightSegmentTransferCheck(SegmentWrapper prev, SegmentWrapper curr) {
        DictionaryReference arrivalPoint = DictHelper.getCity(prev.endLocation);
        DictionaryReference departurePoint = DictHelper.getCity(curr.startLocation);
        if (TextUtil.equals((String)arrivalPoint.getCode(), (String)departurePoint.getCode(), (boolean)false)) {
            boolean arrivalTariffCheck = prev.fareBasis.contains(arrivalPoint.getCode());
            boolean departureTariffCheck = curr.fareBasis.contains(departurePoint.getCode());
            if (arrivalTariffCheck && departureTariffCheck) {
                java.util.Date timeTo = prev.endDate;
                java.util.Date timeFrom = curr.startDate;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(timeTo);
                calendar.add(11, 24);
                if (calendar.getTime().after(timeFrom)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static <T> List<FlightType> initializeOriginDestinations(List<T> segments, Function<T, SegmentWrapper> wrap, Consumer<FareComponentType> fareConsumer) {
        ArrayList<FlightType> result = new ArrayList<FlightType>();
        result.add(new FlightType());
        int flightCounter = 0;
        T prev = segments.get(flightCounter);
        SegmentWrapper prevWrapper = wrap.apply(prev);
        do {
            T curr = segments.get(flightCounter++);
            SegmentWrapper currWrapper = wrap.apply(curr);
            S7NDCHelper.prepareFlight(prevWrapper, currWrapper, result, flightCounter, fareConsumer);
            prevWrapper = currWrapper;
        } while (flightCounter < segments.size());
        return result;
    }

    public static void prepareFlight(SegmentWrapper prev, SegmentWrapper curr, List<FlightType> tmpOriginDestList, int countFlightSegments, Consumer<FareComponentType> fareConsumer) {
        if (!S7NDCHelper.flightSegmentTransferCheck(prev, curr) && !tmpOriginDestList.get(tmpOriginDestList.size() - 1).getFlightList().isEmpty()) {
            tmpOriginDestList.add(new FlightType());
        }
        String segmentKey = String.join((CharSequence)"", "FL", String.valueOf(countFlightSegments));
        FlightType.Flight fl = new FlightType.Flight();
        SegmentKey segK = new SegmentKey();
        segK.setSegmentKey(segmentKey);
        fl.setSegmentKey(segK);
        fl.setDeparture(S7NDCHelper.buildFlightDepartureType(curr.startLocation, curr.startDate));
        fl.setArrival(S7NDCHelper.buildFlightArrivalType(curr.endLocation, curr.endDate));
        fl.setMarketingCarrier(S7NDCHelper.buildMarketingCarrierFlightType(curr.airlineRef, curr.flightNumber));
        fl.setOperatingCarrier(S7NDCHelper.buildFlightOperatingCarrier(curr.operatingAirlineOrCodeShareCarrier, curr.operatingFlightNumberOrCodeShareFlightNo));
        tmpOriginDestList.get(tmpOriginDestList.size() - 1).getFlightList().add(fl);
        FareComponentType fareComponent = new FareComponentType();
        ObjectKeyMetaAttrGroup objectKeyMetaAttrGroup = new ObjectKeyMetaAttrGroup();
        objectKeyMetaAttrGroup.setRefs(segmentKey);
        fareComponent.setObjectKeyMetaAttrGroup(objectKeyMetaAttrGroup);
        FareComponentType.FareBasis fareBasis = new FareComponentType.FareBasis();
        FareBasisCodeType fareBasisCode = new FareBasisCodeType();
        fareBasisCode.setCode(curr.fareBasis);
        if (fareConsumer != null) {
            fareBasis.setFareBasisCode(fareBasisCode);
            fareBasis.setRBD(curr.bookingOrOfSvcCodeClass);
            fareComponent.setFareBasis(fareBasis);
            fareConsumer.accept(fareComponent);
        } else {
            FlightCOSCoreType flightCOSCoreType = new FlightCOSCoreType();
            flightCOSCoreType.setCodeString(curr.bookingOrOfSvcCodeClass);
            fl.setClassOfService(flightCOSCoreType);
        }
    }

    public static List<List<Segment>> groupSegmentsByTransferSign(List<Segment> allocatedSegments) {
        ArrayList<List<Segment>> result = new ArrayList<List<Segment>>();
        result.add(new ArrayList());
        int i = 0;
        SegmentWrapper prevSegWrapper = new SegmentWrapper(allocatedSegments.get(0));
        do {
            Segment currSeg;
            SegmentWrapper currSegWrapper;
            if (!S7NDCHelper.flightSegmentTransferCheck(prevSegWrapper, currSegWrapper = new SegmentWrapper(currSeg = allocatedSegments.get(i++))) && !((List)result.get(result.size() - 1)).isEmpty()) {
                result.add(new ArrayList());
            }
            ((List)result.get(result.size() - 1)).add(currSeg);
            prevSegWrapper = currSegWrapper;
        } while (i < allocatedSegments.size());
        return result;
    }

    public static Pair<String> getAccountCodeParts(String accountCode) {
        String[] accountCodeParts = accountCode.split("/");
        return new Pair((Object)accountCodeParts[0], (Object)accountCodeParts[1]);
    }

    public static ListOfOfferInstructionsType.Instruction buildAccountCodeInstruction(String accountCode) {
        return S7NDCHelper.buildAccountCodeInstruction(S7NDCHelper.getAccountCodeParts(accountCode));
    }

    public static ListOfOfferInstructionsType.Instruction buildAccountCodeInstruction(Pair<String> accountCodeParts) {
        ListOfOfferInstructionsType.Instruction instruction = new ListOfOfferInstructionsType.Instruction();
        DataListObjAttrGroup dataListObjAttrGroup = new DataListObjAttrGroup();
        dataListObjAttrGroup.setListKey("CC");
        instruction.setDataListObjAttrGroup(dataListObjAttrGroup);
        CodesetType specialBookingInstruction = new CodesetType();
        specialBookingInstruction.setCode((String)accountCodeParts.getFirst());
        specialBookingInstruction.setDefinition((String)accountCodeParts.getLast());
        instruction.setSpecialBookingInstruction(specialBookingInstruction);
        return instruction;
    }

    public static FareQualifierType buildAccountCodeFareQualifier(String accountCode) {
        Pair<String> accountCodeParts = S7NDCHelper.getAccountCodeParts(accountCode);
        FareQualifierType result = new FareQualifierType();
        AirlineIDType airlineID = new AirlineIDType();
        airlineID.setString(S7_AIRLINE_ID);
        result.setAirlineID(airlineID);
        FareQualifierType.CompanyIndex companyIndex = new FareQualifierType.CompanyIndex();
        companyIndex.setString((String)accountCodeParts.getFirst());
        result.setCompanyIndex(companyIndex);
        FareQualifierType.Account account = new FareQualifierType.Account();
        account.setString((String)accountCodeParts.getLast());
        result.setAccount(account);
        return result;
    }

    public static SrvPriceReqParamsType.ServiceFilters buildBaggageServiceFilters() {
        SrvPriceReqParamsType.ServiceFilters filters = new SrvPriceReqParamsType.ServiceFilters();
        filters.setServiceFilterList(new ArrayList());
        ServiceFilterType filter = new ServiceFilterType();
        filter.setGroupCode("baggage");
        filters.getServiceFilterList().add(filter);
        return filters;
    }

    public static java.util.Date convertTimeLimit(OrderCoreType.TimeLimits.PaymentTimeLimit paymentTimeLimit, Pcc ticketingPcc) {
        java.util.Date timelimit = paymentTimeLimit.getDateTime();
        long systemOffset = (long)ZoneId.systemDefault().getRules().getOffset(timelimit.toInstant()).getTotalSeconds() * 1000L;
        long utcOffset = (long)ZoneId.of("UTC").getRules().getOffset(timelimit.toInstant()).getTotalSeconds() * 1000L;
        long delta = systemOffset - utcOffset;
        timelimit = new java.util.Date(timelimit.getTime() - delta);
        return GDSHelper.convertTimelimitFromPcc((java.util.Date)timelimit, (Pcc)ticketingPcc);
    }

    public static PenaltiesInfo getPenaltiesInfo(PenaltyType penaltyType) {
        PenaltiesInfo penaltiesInfo = new PenaltiesInfo();
        penaltyType.getDetails().getDetailList().forEach(detail -> {
            block26: {
                switch (detail.getType()) {
                    case "BEFORE-DEPARTURE": {
                        switch (detail.getApplication().getCode()) {
                            case "changePenalty": {
                                if (!CollectionUtil.isNotEmpty((Collection)detail.getAmounts().getAmountList())) break;
                                detail.getAmounts().getAmountList().forEach(amount -> {
                                    switch (amount.getAmountApplication()) {
                                        case "MaximumPenaltyAmount": {
                                            penaltiesInfo.setExchangableBeforeDeparture(Boolean.TRUE);
                                            penaltiesInfo.setExchangeBeforeDeparture(MoneyHelper.buildMoney((BigDecimal)amount.getCurrencyAmountValue().getDecimal(), (String)amount.getCurrencyAmountValue().getCode()));
                                        }
                                    }
                                });
                                return;
                            }
                            case "cancellationAndRefundPenalty": {
                                if (!CollectionUtil.isNotEmpty((Collection)detail.getAmounts().getAmountList())) break;
                                detail.getAmounts().getAmountList().forEach(amount -> {
                                    switch (amount.getAmountApplication()) {
                                        case "MaximumPenaltyAmount": {
                                            penaltiesInfo.setRefundableBeforeDeparture(Boolean.TRUE);
                                            penaltiesInfo.setRefundBeforeDeparture(MoneyHelper.buildMoney((BigDecimal)amount.getCurrencyAmountValue().getDecimal(), (String)amount.getCurrencyAmountValue().getCode()));
                                        }
                                    }
                                });
                            }
                        }
                        return;
                    }
                    case "AFTER-DEPARTURE": {
                        switch (detail.getApplication().getCode()) {
                            case "changePenalty": {
                                if (!CollectionUtil.isNotEmpty((Collection)detail.getAmounts().getAmountList())) return;
                                detail.getAmounts().getAmountList().forEach(amount -> {
                                    switch (amount.getAmountApplication()) {
                                        case "MaximumPenaltyAmount": {
                                            penaltiesInfo.setExchangableAfterDeparture(Boolean.TRUE);
                                            penaltiesInfo.setExchangeAfterDeparture(MoneyHelper.buildMoney((BigDecimal)amount.getCurrencyAmountValue().getDecimal(), (String)amount.getCurrencyAmountValue().getCode()));
                                        }
                                    }
                                });
                                break block26;
                            }
                            case "cancellationAndRefundPenalty": {
                                if (!CollectionUtil.isNotEmpty((Collection)detail.getAmounts().getAmountList())) return;
                                detail.getAmounts().getAmountList().forEach(amount -> {
                                    switch (amount.getAmountApplication()) {
                                        case "MaximumPenaltyAmount": {
                                            penaltiesInfo.setRefundableAfterDeparture(Boolean.TRUE);
                                            penaltiesInfo.setRefundAfterDeparture(MoneyHelper.buildMoney((BigDecimal)amount.getCurrencyAmountValue().getDecimal(), (String)amount.getCurrencyAmountValue().getCode()));
                                        }
                                    }
                                });
                            }
                        }
                    }
                }
            }
        });
        return penaltiesInfo;
    }

    public static String getRecordLocator(Reservation reservation) {
        return ReservationGdsNameInfoHelper.getOnlineRecordLocator((Reservation)reservation, (RecordLocatorType)RecordLocatorType.DEFAULT);
    }
}

