/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc;

import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import java.util.Date;

public class SegmentWrapper {
    final DictionaryReference<GeoLocation> startLocation;
    final DictionaryReference<GeoLocation> endLocation;
    final Date startDate;
    final Date endDate;
    final DictionaryReference<Airline> airlineRef;
    final String flightNumber;
    final String bookingOrOfSvcCodeClass;
    final String fareBasis;
    final DictionaryReference<Airline> operatingAirlineOrCodeShareCarrier;
    final String operatingFlightNumberOrCodeShareFlightNo;

    public SegmentWrapper(Segment segment) {
        this.startLocation = segment.getDepartureLocation();
        this.endLocation = segment.getArriveLocation();
        this.startDate = segment.getStartDate();
        this.endDate = segment.getEndDate();
        this.airlineRef = segment.getAirline();
        this.flightNumber = segment.getFlightNo();
        this.bookingOrOfSvcCodeClass = segment.getClassOfSvcCode();
        this.fareBasis = segment.getFareBasis();
        this.operatingAirlineOrCodeShareCarrier = segment.getCodeShareCarrier();
        this.operatingFlightNumberOrCodeShareFlightNo = segment.getCodeShareFlightNo();
    }

    public SegmentWrapper(FlightSegment flightSegment) {
        this.startLocation = flightSegment.getLocationBegin();
        this.endLocation = flightSegment.getLocationEnd();
        this.startDate = flightSegment.getDateBegin();
        this.endDate = flightSegment.getDateEnd();
        this.airlineRef = flightSegment.getAirline();
        this.flightNumber = flightSegment.getFlightNumber();
        this.bookingOrOfSvcCodeClass = flightSegment.getBookingClass();
        this.fareBasis = flightSegment.getFareInfos().stream().filter(fi -> fi.getPassengerType().equals((Object)DictHelper.getAdultPassengerType())).findAny().get().getFareBasis();
        this.operatingAirlineOrCodeShareCarrier = flightSegment.getOperatingAirline();
        this.operatingFlightNumberOrCodeShareFlightNo = flightSegment.getOperatingFlightNumber();
    }
}

