/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.cancelAncillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class CheckForCancelAncillaryFeesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Collection productsForCancel = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BASE_PRODUCTS);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        for (Reservation reservation : BookingHelper.getReservationsForProduct((BookingFile)((BookingFile)bookingCtr.getEntity()), (Class[])new Class[]{Product.class})) {
            Collection allProducts = GDSHelper.getAllProducts((Reservation)reservation).stream().filter(mcoProduct -> mcoProduct.getStatus() == ProductStatus.BOOKING).collect(Collectors.toList());
            ArrayList mcoProductsGroupByTickets = GDSHelper.groupProductsByTickets((Collection)allProducts);
            for (List mcoProducts : mcoProductsGroupByTickets) {
                List productsAfterCancel = mcoProducts.stream().filter(product -> !CollectionUtil.contains((Collection)productsForCancel, (Object)product, (o1, o2) -> TextUtil.equals((String)o1.getUid(), (String)o2.getUid(), (boolean)false))).collect(Collectors.toList());
                Collection productGroupsAfterCancel = AirProductHelper.getProductsGroupBySegmentGroups(productsAfterCancel);
                if (S7NDCHelper.isCorrectRemainingProducts(productGroupsAfterCancel)) continue;
                throw Xeption.forDeveloper((String)"\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0443\u0441\u043b\u0443\u0433\u0438 \u0432\u044b\u0431\u0440\u0430\u043d\u044b \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e", (Object[])new Object[0]);
            }
        }
    }
}

