/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.db;

import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.update.db.SetupUpdateHandler;
import org.w3c.dom.Element;

public class S7NDCPassengerTypeUpdateHandler
implements SetupUpdateHandler {
    public void execute(Element command) throws Exception {
        this.setCode(PassengerTypeValue.ADULT, "ADT");
        this.setCode(PassengerTypeValue.CHILD, "CHD");
        this.setCode(PassengerTypeValue.INFANT, "INF");
    }

    private void setCode(PassengerTypeValue ptv, String code) throws Exception {
        PassengerType pt = (PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)ptv);
        pt.getCodeVariants().put(CodeSystem.S7NDC.name(), code);
        pt.setDataSource("S7NDCPassengerTypeUpdateHandler");
        DictionaryStorage.get().save((BaseDictionary)pt);
    }
}

