/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052;

import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AnonymousTravelerList;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.DataListType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfBagAllowanceType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfCarryOnAllowanceType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfFlightSegmentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfOfferPenaltyType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OriginDestination;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OriginDestinationType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PenaltyType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DataListsIndex {
    private final Map<String, TravelerCoreType> anonymousTravelers;
    private final Map<String, OriginDestination> originDestinations;
    private final Map<String, ListOfFlightSegmentType> flightSegments;
    private final Map<String, ListOfBagAllowanceType.CheckedBagAllowance> checkedBagAllowances;
    private final Map<String, ListOfCarryOnAllowanceType.CarryOnAllowance> carryOnAllowances;
    private final Map<String, PenaltyType> penaltyTypes;

    public DataListsIndex(DataListType dataLists) {
        this.anonymousTravelers = Optional.ofNullable(dataLists.getAnonymousTravelerList()).map(AnonymousTravelerList::getAnonymousTravelerList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(v -> v.getObjectKeyAttrGroup().getObjectKey(), Function.identity()));
        this.originDestinations = Optional.ofNullable(dataLists.getOriginDestinationList()).map(DataListType.OriginDestinationList::getOriginDestinationList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(OriginDestinationType::getOriginDestinationKey, Function.identity()));
        this.flightSegments = Optional.ofNullable(dataLists.getFlightSegmentList()).map(DataListType.FlightSegmentList::getFlightSegmentList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(ListOfFlightSegmentType::getSegmentKey, Function.identity()));
        this.checkedBagAllowances = Optional.ofNullable(dataLists.getCheckedBagAllowanceList()).map(ListOfBagAllowanceType::getCheckedBagAllowanceList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(v -> v.getDataListObjAttrGroup().getListKey(), Function.identity()));
        this.carryOnAllowances = Optional.ofNullable(dataLists.getCarryOnAllowanceList()).map(ListOfCarryOnAllowanceType::getCarryOnAllowanceList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(v -> v.getDataListObjAttrGroup().getListKey(), Function.identity()));
        this.penaltyTypes = Optional.ofNullable(dataLists.getPenaltyList()).map(ListOfOfferPenaltyType::getPenaltyList).orElseGet(Collections::emptyList).stream().collect(Collectors.toMap(v -> v.getObjectKeyMetaAttrGroup().getObjectKey(), Function.identity()));
    }

    public TravelerCoreType getAnonymousTraveler(String key) {
        return this.anonymousTravelers.get(key);
    }

    public OriginDestination getOriginDestination(String key) {
        return this.originDestinations.get(key);
    }

    public ListOfFlightSegmentType getFlightSegment(String key) {
        return this.flightSegments.get(key);
    }

    public ListOfBagAllowanceType.CheckedBagAllowance getCheckedBagAllowance(String key) {
        return this.checkedBagAllowances.get(key);
    }

    public ListOfCarryOnAllowanceType.CarryOnAllowance getCarryOnAllowance(String key) {
        return this.carryOnAllowances.get(key);
    }

    public PenaltyType getPenaltyType(String key) {
        return this.penaltyTypes.get(key);
    }
}

