/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareDetails;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightPassengerTypeData;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TechStopInfo;
import com.gridnine.xtrip.common.model.booking.TripartiteContractDetails;
import com.gridnine.xtrip.common.model.booking.air.LuggageInfo;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LuggageDimensionUnit;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.gds.s7ndc.S7NDCGdsAccount;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.profile.AFSType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.v052.DataListsIndex;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.BagAllowanceDescType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Description;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareComponentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareFilingType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightDetailType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightSegmentReference;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfFlightSegmentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OfferPriceLeadType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OriginDestination;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OtherOfferAssocType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PricedFlightOfferAssocType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.StopLocationType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TaxDetailType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FlightConverterHelper {
    private static final Pattern P_WEIGHT_UP_TO = Pattern.compile("Up to [0-9]+ lb/(?<value>[0-9]+) kg", 2);
    private static final Pattern P_WEIGHT = Pattern.compile("(?<value>\\d+) *KG", 2);
    private static final Pattern P_DIMENSIONS = Pattern.compile("Up to [0-9]+ li/(?<value>[0-9]+) lcm", 2);

    public static FlightSegment buildFlightSegment(ListOfFlightSegmentType gdsFlightSegment) throws Exception {
        FlightSegment fs = new FlightSegment();
        fs.setLocationBegin(S7NDCHelper.resolveIataNativeCode(GeoLocation.class, gdsFlightSegment.getDeparture().getAirportCodeString()));
        fs.setDateBegin(S7NDCHelper.buildDateTime(gdsFlightSegment.getDeparture().getDate(), gdsFlightSegment.getDeparture().getTime1()));
        if (gdsFlightSegment.getDeparture().getTerminal() != null) {
            fs.setTerminalBegin(gdsFlightSegment.getDeparture().getTerminal().getName());
        }
        fs.setLocationEnd(S7NDCHelper.resolveIataNativeCode(GeoLocation.class, gdsFlightSegment.getArrival().getAirportCodeString()));
        fs.setDateEnd(S7NDCHelper.buildDateTime(gdsFlightSegment.getArrival().getDate(), gdsFlightSegment.getArrival().getTime1()));
        if (gdsFlightSegment.getArrival().getTerminal() != null) {
            fs.setTerminalEnd(gdsFlightSegment.getArrival().getTerminal().getName());
        }
        fs.setAirline(S7NDCHelper.resolveIataNativeCode(Airline.class, gdsFlightSegment.getMarketingCarrier().getAirlineID().getString()));
        fs.setFlightNumber(gdsFlightSegment.getMarketingCarrier().getFlightNumber().getString());
        fs.setOperatingAirline(S7NDCHelper.resolveIataNativeCode(Airline.class, gdsFlightSegment.getOperatingCarrier().getAirlineID().getString()));
        if (gdsFlightSegment.getOperatingCarrier().getFlightNumber() != null) {
            fs.setOperatingFlightNumber(gdsFlightSegment.getOperatingCarrier().getFlightNumber().getString());
        } else {
            fs.setOperatingFlightNumber(fs.getFlightNumber());
        }
        fs.setTravelDuration((int)Duration.parse(gdsFlightSegment.getFlightDetail().getFlightDuration().getValue()).toMinutes());
        fs.setBoard(S7NDCHelper.resolveIataNativeCode(Aircraft.class, gdsFlightSegment.getEquipment().getAircraftCode().getString()));
        fs.addTechStopInfos(FlightConverterHelper.buildTechStopInfo(gdsFlightSegment.getFlightDetail().getStops()));
        return fs;
    }

    private static Collection<TechStopInfo> buildTechStopInfo(FlightDetailType.Stops stops) {
        ArrayList<TechStopInfo> result;
        block5: {
            block4: {
                if (stops == null) {
                    return null;
                }
                result = new ArrayList<TechStopInfo>();
                StopLocationType stopLocations = stops.getStopLocations();
                if (stopLocations == null || !CollectionUtil.isNotEmpty((Collection)stopLocations.getStopLocationList())) break block4;
                for (StopLocationType.StopLocation stopLocation : stopLocations.getStopLocationList()) {
                    TechStopInfo stopInfo = new TechStopInfo();
                    stopInfo.setLocation(S7NDCHelper.resolveIataNativeCode(GeoLocation.class, stopLocation.getAirportCode().getString()));
                    if (stopLocation.getGroundTime() != null) {
                        stopInfo.setDuration((int)Duration.parse(stopLocation.getGroundTime()).toMinutes());
                    }
                    result.add(stopInfo);
                }
                break block5;
            }
            if (!TextUtil.nonBlank((String)stops.getStopQuantity())) break block5;
            int stopCount = Integer.parseInt(stops.getStopQuantity());
            for (int i = 0; i < stopCount; ++i) {
                result.add(new TechStopInfo());
            }
        }
        return result;
    }

    public static Flight buildFlight(String accountCode, EntityContainer<S7NDCGdsAccount> gdsAccountCtr, List<TravelerCoreType> anonymousTravelers, List<OfferPriceLeadType> offerPriceList, DataListsIndex index, SalesContext salesContext) throws Exception {
        Flight flight = new Flight();
        flight.setSalesOriginContent(SalesOriginContent.DIRECT_CHANNEL);
        flight.setSalesOriginProvider(SalesOriginProvider.DIRECT_CHANNEL);
        flight.setAccountCodeApplied(true);
        flight.setAccountCode(accountCode);
        flight.setCarrier(S7NDCHelper.getS7AirlineReference());
        flight.setGdsCurrencyCode(((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getCurrency().getCode());
        flight.setGds(GdsName.S7NDC);
        flight.setEticket(true);
        flight.setLatinRegistration(true);
        flight.setGdsAccount(gdsAccountCtr.toReference());
        flight.getSeats().addAll(anonymousTravelers.stream().map(anonymousTraveler -> {
            SeatPreferences sp = new SeatPreferences();
            sp.setPassengerType(S7NDCHelper.resolveS7NDCNativeCode(PassengerType.class, anonymousTraveler.getPTC1().getString()));
            sp.setCount(anonymousTraveler.getPTC1().getQuantity().intValue());
            return sp;
        }).collect(Collectors.toList()));
        boolean needP3dBkg = StatisticsHelper.getInputableAfsTypesFromString((String)((Organization)EntityStorage.get().resolve(salesContext.getClient()).getEntity()).getAfsSettings(), (boolean)false).contains(AFSType.P3D);
        boolean needP3dTkt = StatisticsHelper.getInputableAfsTypesFromString((String)((Organization)EntityStorage.get().resolve(salesContext.getClient()).getEntity()).getAfsSettings(), (boolean)true).contains(AFSType.P3D);
        for (OfferPriceLeadType offerPrice : offerPriceList) {
            FlightSegmentTariff fst = new FlightSegmentTariff();
            HashMap<String, FlightSegment> flightSegments = new HashMap<String, FlightSegment>();
            for (PricedFlightOfferAssocType associations : offerPrice.getRequestedDateAssociationList()) {
                if (associations.getApplicableFlight() == null) continue;
                if (flightSegments.isEmpty()) {
                    OriginDestination originDestination = index.getOriginDestination(associations.getApplicableFlight().getSequence().getOriginDestinationReferences().getOriginDestinationReferences());
                    StringTokenizer st = new StringTokenizer(originDestination.getFlightReferences().getString(), " ");
                    boolean starting = true;
                    while (st.hasMoreTokens()) {
                        String seg = st.nextToken();
                        ListOfFlightSegmentType gdsFlightSegment = index.getFlightSegment(seg);
                        FlightSegment fs = FlightConverterHelper.buildFlightSegment(gdsFlightSegment);
                        fs.setStarting(starting);
                        starting = false;
                        fs.setGdsId(seg);
                        fst.getSegments().add(fs);
                        flightSegments.put(seg, fs);
                    }
                }
                String travelerKey = associations.getAssociatedTraveler().getTravelerReferences().getTravelerReferences();
                DictionaryReference<PassengerType> passengerType = S7NDCHelper.resolveS7NDCNativeCode(PassengerType.class, index.getAnonymousTraveler(travelerKey).getPTC1().getString());
                for (FlightSegmentReference flightSegmentReference : associations.getApplicableFlight().getSequence().getFlightSegmentReferenceList()) {
                    BagAllowanceDescType carryOnBaggage;
                    ExtendedLuggageInfo carryOnBaggageExtended;
                    FareInfo fi2;
                    FlightSegment fs = (FlightSegment)flightSegments.get(flightSegmentReference.getRef());
                    Optional<FareInfo> fiOpt = fs.getFareInfos().stream().filter(fi -> fi.getPassengerType().equals((Object)passengerType)).findAny();
                    Optional<Object> referenceValue = associations.getOtherAssociation() != null ? associations.getOtherAssociation().getOtherAssociationList().stream().map(OtherOfferAssocType.OtherAssociation::getReferenceValue).findAny() : Optional.empty();
                    if (fiOpt.isPresent()) {
                        fi2 = fiOpt.get();
                    } else {
                        fi2 = new FareInfo();
                        fi2.setPassengerType(passengerType);
                        referenceValue.ifPresent(s -> fi2.setPenaltiesInfo(S7NDCHelper.getPenaltiesInfo(index.getPenaltyType((String)s))));
                        fs.getFareInfos().add(fi2);
                    }
                    if (flightSegmentReference.getCabin() != null) {
                        fs.setServiceClass(S7NDCHelper.getClassOfService(flightSegmentReference.getCabin().getCabinDesignatorString()));
                        FareDetails fd = new FareDetails();
                        L10nStringHelper.setValue((L10nString)fd.getBrandName(), (String)flightSegmentReference.getCabin().getMarketingName(), (Locale)Locale.ROOT);
                        FarePricingParameters pricingParameters = new FarePricingParameters();
                        pricingParameters.setBrandId(flightSegmentReference.getCabin().getMarketingName());
                        fd.setPricingParameters(pricingParameters);
                        fi2.setFareDetails(fd);
                    }
                    if (flightSegmentReference.getClassOfService() != null) {
                        fs.setBookingClass(flightSegmentReference.getClassOfService().getCodeString());
                        fs.setAvailableSeats(flightSegmentReference.getClassOfService().getCodeSeatsLeft());
                        fi2.setFareBasis(flightSegmentReference.getClassOfService().getMarketingName().getString());
                    }
                    fi2.setRemarksSearchContext(S7NDCHelper.getS7NDCNativeCode(passengerType));
                    if (flightSegmentReference.getBagDetailAssociation() == null) continue;
                    BagAllowanceDescType checkedBaggage = index.getCheckedBagAllowance(flightSegmentReference.getBagDetailAssociation().getCheckedBagReferences().getCheckedBagReferences()).getAllowanceDescription();
                    fi2.setLuggageInfo(AirProductHelper.parseLuggageInfo((String)checkedBaggage.getApplicableBag()));
                    ExtendedLuggageInfo checkedBaggageExtended = FlightConverterHelper.buildExtendedLuggageInfo(checkedBaggage);
                    if (checkedBaggageExtended != null) {
                        fi2.setExtendedLuggageInfo(checkedBaggageExtended);
                        fi2.getFareDetails().setLuggageInfo(checkedBaggageExtended);
                    }
                    if (flightSegmentReference.getBagDetailAssociation().getCarryOnReferences() == null || (carryOnBaggageExtended = FlightConverterHelper.buildExtendedLuggageInfo(carryOnBaggage = index.getCarryOnAllowance(flightSegmentReference.getBagDetailAssociation().getCarryOnReferences().getCarryOnReferences()).getAllowanceDescription())) == null) continue;
                    fi2.getFareDetails().setCabinLuggageInfo(carryOnBaggageExtended);
                }
            }
            flight.getSegmentTariffs().add(fst);
            for (FareComponentType fareComponent : offerPrice.getFareDetail().getFareComponentList()) {
                FlightPassengerTypeData passengerTypeData;
                StatisticalData statisticalData;
                boolean hasDiscount;
                TaxDetailType taxes;
                DictionaryReference<PassengerType> passengerType = S7NDCHelper.resolveS7NDCNativeCode(PassengerType.class, index.getAnonymousTraveler(fareComponent.getObjectKeyMetaAttrGroup().getRefs()).getPTC1().getString());
                BigDecimal p3d = BigDecimal.ZERO;
                if (fareComponent.getPriceBreakdown().getBaseAmount() != null) {
                    BigDecimal fare = fareComponent.getPriceBreakdown().getBaseAmount().getDecimal();
                    p3d = p3d.add(fare);
                    FlightFare ff = new FlightFare();
                    ff.setPassengerType(passengerType);
                    ff.setEquivalentAmount(fare);
                    ff.setBaseAmount(MoneyHelper.buildMoney((BigDecimal)fare, (String)((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getCurrency().getCode()));
                    ff.setSegmentTariff(fst);
                    flight.getFares().add(ff);
                }
                if ((taxes = fareComponent.getPriceBreakdown().getTaxes()).getBreakdown() != null && !taxes.getBreakdown().getTaxList().isEmpty()) {
                    for (TaxDetailType.Breakdown.Tax tax : taxes.getBreakdown().getTaxList()) {
                        BigDecimal value = tax.getAmount().getDecimal();
                        p3d = p3d.add(value);
                        FlightTax ft = new FlightTax();
                        ft.setPassengerType(passengerType);
                        ft.setSegmentTariff(fst);
                        ft.setCode(tax.getTaxCode());
                        ft.setEquivalentAmount(value);
                        flight.getTaxes().add(ft);
                    }
                } else {
                    BigDecimal xt = taxes.getTotal().getDecimal();
                    p3d = p3d.add(xt);
                    FlightTax ft = new FlightTax();
                    ft.setPassengerType(passengerType);
                    ft.setSegmentTariff(fst);
                    ft.setCode("XT");
                    ft.setEquivalentAmount(xt);
                    flight.getTaxes().add(ft);
                }
                FareFilingType fareFiledIn = fareComponent.getPriceBreakdown().getFareFiledIn();
                boolean bl = hasDiscount = fareFiledIn != null && "Discount".equals(fareFiledIn.getMetadataToken());
                if (hasDiscount) {
                    if (flight.getTripartiteContractDetails() == null) {
                        flight.setTripartiteContractDetails(new TripartiteContractDetails());
                    }
                    flight.getTripartiteContractDetails().setIssuedUnder3d(true);
                }
                if (!needP3dBkg && !needP3dTkt) continue;
                if (hasDiscount) {
                    p3d = p3d.add(fareFiledIn.getBaseAmount().getDecimal());
                }
                if ((statisticalData = (passengerTypeData = FlightHelper.getOrCreatePassengerTypeData((Flight)flight, passengerType)).getStatisticalData()) == null) {
                    statisticalData = new StatisticalData();
                    passengerTypeData.setStatisticalData(statisticalData);
                }
                if (needP3dBkg) {
                    statisticalData.setP3dBkg(Double.valueOf(p3d.doubleValue()));
                }
                if (!needP3dTkt) continue;
                statisticalData.setP3dTkt(Double.valueOf(p3d.doubleValue()));
            }
        }
        return flight;
    }

    private static ExtendedLuggageInfo buildExtendedLuggageInfo(BagAllowanceDescType allowanceDescription) {
        ExtendedLuggageInfo result = new ExtendedLuggageInfo();
        LuggageInfo luggageInfo = AirProductHelper.parseLuggageInfo((String)allowanceDescription.getApplicableBag());
        if (luggageInfo != null) {
            if (luggageInfo.isNil()) {
                return null;
            }
            if (DictHelper.getPcLuggageUnit().toReference().equals((Object)luggageInfo.getUnit())) {
                result.setPieces(luggageInfo.getQuantity());
            } else if (DictHelper.getKgLuggageUnit().toReference().equals((Object)luggageInfo.getUnit())) {
                result.setWeight(luggageInfo.getQuantity());
                result.setWeightUnit((DictionaryReference)DictHelper.getKgLuggageUnit().toReference());
            } else if (DictHelper.getLbLuggageUnit().toReference().equals((Object)luggageInfo.getUnit())) {
                result.setWeight(luggageInfo.getQuantity());
                result.setWeightUnit((DictionaryReference)DictHelper.getLbLuggageUnit().toReference());
            }
        }
        if (allowanceDescription.getDescriptions() != null) {
            Matcher mWeight;
            Description description;
            boolean weightSet = false;
            for (Description description2 : allowanceDescription.getDescriptions().getDescriptionList()) {
                if (description2.getText() == null || description2.getText().getString() == null) continue;
                Matcher mWeightUpTo = P_WEIGHT_UP_TO.matcher(description2.getText().getString());
                if (mWeightUpTo.matches()) {
                    result.setWeight(Integer.valueOf(Integer.parseInt(mWeightUpTo.group("value"))));
                    result.setWeightUnit((DictionaryReference)DictHelper.getKgLuggageUnit().toReference());
                    weightSet = true;
                    continue;
                }
                Matcher mDimensions = P_DIMENSIONS.matcher(description2.getText().getString());
                if (!mDimensions.matches()) continue;
                result.setDimensionsSum(Integer.valueOf(Integer.parseInt(mDimensions.group("value"))));
                result.setDimensionUnit(LuggageDimensionUnit.CENTIMETER);
            }
            if (!weightSet && allowanceDescription.getDescriptions().getDescriptionList().size() == 1 && (description = (Description)allowanceDescription.getDescriptions().getDescriptionList().get(0)).getText() != null && description.getText().getString() != null && (mWeight = P_WEIGHT.matcher(description.getText().getString())).matches()) {
                result.setWeight(Integer.valueOf(Integer.parseInt(mWeight.group("value"))));
                result.setWeightUnit((DictionaryReference)DictHelper.getKgLuggageUnit().toReference());
            }
        }
        return result;
    }

    public static void copyTechStopInfo(Flight oldFlight, Flight newFlight) {
        List oldSegments = FlightHelper.getSegments((Flight)oldFlight);
        List newSegments = FlightHelper.getSegments((Flight)newFlight);
        for (int i = 0; i < oldSegments.size(); ++i) {
            FlightSegment oldSegment = (FlightSegment)oldSegments.get(i);
            FlightSegment newSegment = (FlightSegment)newSegments.get(i);
            if (!newSegment.getTechStopInfos().isEmpty()) continue;
            newSegment.getTechStopInfos().addAll(oldSegment.getTechStopInfos());
        }
    }
}

