/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052;

import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfFlightSegmentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OriginDestination;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OriginDestinationType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServiceAssocType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServiceCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServicePriceRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerReferences;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ServicePriceRSHelper {
    public static <S> Set<Integer> getSegmentNumbers(ServiceCoreType service, List<S> segments, BiFunction<List<S>, ListOfFlightSegmentType, Integer> getSegmentIndexFunction, Map<String, OriginDestination> odDataList, Map<String, ListOfFlightSegmentType> segDataList) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (ServiceAssocType association : service.getAssociationList()) {
            if (association.getFlight() == null) continue;
            for (ServiceAssocType.Flight.Choice choice : association.getFlight().getChoiceList()) {
                if (choice.getOriginDestinationReferences() != null) {
                    StringTokenizer stOD = new StringTokenizer(choice.getOriginDestinationReferences().getOriginDestinationReferences(), " ");
                    while (stOD.hasMoreTokens()) {
                        StringTokenizer stSEG = new StringTokenizer(odDataList.get(stOD.nextToken()).getFlightReferences().getString(), " ");
                        while (stSEG.hasMoreTokens()) {
                            ListOfFlightSegmentType gdsFs = segDataList.get(stSEG.nextToken());
                            result.add(getSegmentIndexFunction.apply(segments, gdsFs));
                        }
                    }
                }
                if (choice.getSegmentReferences() == null) continue;
                StringTokenizer stSEG = new StringTokenizer(choice.getSegmentReferences().getString(), " ");
                while (stSEG.hasMoreTokens()) {
                    ListOfFlightSegmentType gdsFs = segDataList.get(stSEG.nextToken());
                    result.add(getSegmentIndexFunction.apply(segments, gdsFs));
                }
            }
        }
        return result;
    }

    public static Set<String> getPassengerTypeCodes(ServiceCoreType service, Map<String, TravelerCoreType> shDataList) {
        return service.getAssociationList().stream().map(ServiceAssocType::getTraveler).filter(Objects::nonNull).map(ServiceAssocType.Traveler::getTravelerReferences).map(TravelerReferences::getTravelerReferences).flatMap(ref -> Stream.of(ref.split(" "))).map(shDataList::get).map(TravelerCoreType::getPTC1).map(TravelerCoreType.PTC::getString).collect(Collectors.toSet());
    }

    public static Map<String, OriginDestination> getOdDataList(ServicePriceRS response) {
        return response.getDataLists().getOriginDestinationList().getOriginDestinationList().stream().collect(Collectors.toMap(OriginDestinationType::getOriginDestinationKey, Function.identity()));
    }

    public static Map<String, ListOfFlightSegmentType> getSegDataList(ServicePriceRS response) {
        return response.getDataLists().getFlightSegmentList().getFlightSegmentList().stream().collect(Collectors.toMap(ListOfFlightSegmentType::getSegmentKey, Function.identity()));
    }

    public static Map<String, TravelerCoreType> getShDataList(ServicePriceRS response) {
        if (response.getDataLists().getAnonymousTravelerList() == null) {
            return Collections.emptyMap();
        }
        return response.getDataLists().getAnonymousTravelerList().getAnonymousTravelerList().stream().collect(Collectors.toMap(at -> at.getObjectKeyAttrGroup().getObjectKey(), Function.identity()));
    }
}

