/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.BookingAirlineBonusCard;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.SegmentWrapper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirlineIDType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Contacts;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.DataListType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.DetailedFlightItem;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.EmailContact;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.EmailIDType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightInfoAssocType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightReferences;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ItemIDType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfOfferInstructionsType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ObjectKeyAttrGroup;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OfferItemID;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OfferItemType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderCreateRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderOfferItemType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Passenger;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PassengerReference;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PassengerSummaryType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PhoneContact;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PhoneType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ShoppingResponseOrderType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerFQTVType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerGenderSimpleType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerSummaryType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigInteger;
import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class OrderCreateRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Flight flight = parameters.getFlight();
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        OrderCreateRQ request = new OrderCreateRQ();
        int travCounter = 1;
        for (Traveller traveller : travellers) {
            Passenger passenger = new Passenger();
            TravelerCoreType.Age age = new TravelerCoreType.Age();
            age.setBirthDate(new Date(traveller.getPassport().getBirthday().getTime()));
            passenger.setAge(age);
            ObjectKeyAttrGroup objectKeyAttrGroup = new ObjectKeyAttrGroup();
            objectKeyAttrGroup.setObjectKey(String.join((CharSequence)"", "SH", String.valueOf(travCounter)));
            passenger.setObjectKeyAttrGroup(objectKeyAttrGroup);
            TravelerCoreType.PTC ptc1 = new TravelerCoreType.PTC();
            GdsTraveller gdsTraveller = parameters.getGdsTravellers().stream().filter(t -> t.getTravellerUid().equals(traveller.getUid())).findAny().get();
            ptc1.setString(S7NDCHelper.getS7NDCNativeCode(gdsTraveller.getPassengerType()));
            ptc1.setQuantity(BigInteger.ONE);
            passenger.setPTC1(ptc1);
            TravelerSummaryType.Given given = new TravelerSummaryType.Given();
            given.setString(traveller.getPassport().getFirstName());
            passenger.getGivenList().add(given);
            passenger.setNameSurnameString(traveller.getPassport().getLastName());
            passenger.setNameTitle(traveller.getPassport().getGender() == Gender.MALE ? "MR" : "MRS");
            if (!traveller.getCommunications().isEmpty()) {
                Optional<Communication> opt;
                Communication communicationPhone;
                Contacts.Contact contact = new Contacts.Contact();
                Communication communicationEmail = traveller.getCommunications().stream().filter(c -> c.getType().equals((Object)CommunicationType.EMAIL)).findAny().orElse(null);
                if (communicationEmail != null) {
                    EmailContact emailContact = new EmailContact();
                    EmailIDType address = new EmailIDType();
                    address.setString(ProfileHelper.normalizeCommunicationPart((String)communicationEmail.getSense()));
                    emailContact.setAddress(address);
                    contact.setEmailContact(emailContact);
                }
                if ((communicationPhone = (opt = traveller.getCommunications().stream().filter(c -> c.getType().equals((Object)CommunicationType.HOME_PHONE) || c.getType().equals((Object)CommunicationType.MOBILE)).findAny()).orElseGet(() -> traveller.getCommunications().stream().filter(c -> c.getType().equals((Object)CommunicationType.WORK_PHONE)).findAny().orElse(null))) != null) {
                    PhoneContact phoneContact = new PhoneContact();
                    PhoneType._Number number = new PhoneType._Number();
                    number.setAreaCode(ProfileHelper.normalizeCommunicationPart((String)communicationPhone.getCityCode()));
                    number.setCountryCode(ProfileHelper.normalizeCommunicationPart((String)communicationPhone.getCountryCode()));
                    number.setString(ProfileHelper.normalizeCommunicationPart((String)communicationPhone.getSense()));
                    phoneContact.getNumberList().add(number);
                    contact.setPhoneContact(phoneContact);
                }
                if (contact.getEmailContact() != null || contact.getPhoneContact() != null) {
                    Contacts contacts = new Contacts();
                    contacts.getContactList().add(contact);
                    passenger.setContacts(contacts);
                }
            }
            PassengerSummaryType.Gender gender = new PassengerSummaryType.Gender();
            gender.setTravelerGenderSimpleType(traveller.getPassport().getGender() == Gender.MALE ? TravelerGenderSimpleType.MALE : TravelerGenderSimpleType.FEMALE);
            passenger.setGender(gender);
            PassengerSummaryType.PassengerIDInfo passengerIDInfo = new PassengerSummaryType.PassengerIDInfo();
            PassengerSummaryType.PassengerIDInfo.PassengerDocument passengerDocument = new PassengerSummaryType.PassengerIDInfo.PassengerDocument();
            Passport passport = traveller.getPassport();
            passengerDocument.setType("PP");
            passengerDocument.setID(passport.getNumber());
            passengerDocument.setBirthCountry(S7NDCHelper.getIataNativeCode(passport.getCitizenship()));
            if (passport.getIssued() != null) {
                passengerDocument.setDateOfIssue(new Date(MiscUtil.clearTime((java.util.Date)passport.getIssued()).getTime()));
            } else {
                passengerDocument.setDateOfIssue(Date.valueOf(LocalDate.now().minusDays(10L)));
            }
            if (passport.getExpired() != null) {
                passengerDocument.setDateOfExpiration(new Date(MiscUtil.clearTime((java.util.Date)passport.getExpired()).getTime()));
            } else {
                passengerDocument.setDateOfExpiration(GDSHelper.getPassportExpirationDate((Passport)passport, (Flight)flight));
            }
            passengerDocument.setCountryOfResidence(S7NDCHelper.getIataNativeCode(passport.getCitizenship()));
            passengerIDInfo.getPassengerDocumentList().add(passengerDocument);
            passenger.setPassengerIDInfo(passengerIDInfo);
            if (!traveller.getAirlineBonusCards().isEmpty()) {
                PassengerSummaryType.FQTVs fqtvs = new PassengerSummaryType.FQTVs();
                for (BookingAirlineBonusCard babc : traveller.getAirlineBonusCards()) {
                    TravelerFQTVType tfqtvi = new TravelerFQTVType();
                    AirlineIDType airlineID = new AirlineIDType();
                    airlineID.setString(S7NDCHelper.getIataNativeCode(babc.getAirline()));
                    tfqtvi.setAirlineID(airlineID);
                    TravelerFQTVType.Account account = new TravelerFQTVType.Account();
                    account.setNumberString(babc.getNumber());
                    tfqtvi.setAccount(account);
                    tfqtvi.setProgramID(S7NDCHelper.getIataNativeCode(babc.getAirline()));
                    fqtvs.getTravelerFQTVInformationList().add(tfqtvi);
                }
                passenger.setFQTVs1(fqtvs);
            }
            request.getQueryPassengerList().add(passenger);
            ++travCounter;
        }
        ShoppingResponseOrderType srot = new ShoppingResponseOrderType();
        srot.setOwner(S7NDCHelper.getIataNativeCode(flight.getCarrier()));
        srot.setResponseIDString("UNKNOWN");
        ShoppingResponseOrderType.Offer offer = new ShoppingResponseOrderType.Offer();
        ItemIDType itemIDType = new ItemIDType();
        itemIDType.setOwner(S7NDCHelper.getIataNativeCode(flight.getCarrier()));
        itemIDType.setString("UNKNOWN");
        offer.setOfferID(itemIDType);
        ShoppingResponseOrderType.Offer.OfferItem offerItem = new ShoppingResponseOrderType.Offer.OfferItem();
        OfferItemID offerItemID = new OfferItemID();
        offerItemID.setOwner(S7NDCHelper.getIataNativeCode(flight.getCarrier()));
        offerItemID.setString("UNKNOWN");
        offerItem.setOfferItemID(offerItemID);
        PassengerReference passengers = new PassengerReference();
        StringBuilder sb = new StringBuilder();
        int counter = 1;
        for (SeatPreferences seatPreferences : flight.getSeats()) {
            for (int i = 0; i < seatPreferences.getCount(); ++i) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append("SH").append(counter);
                ++counter;
            }
        }
        passengers.setPassengerReference(sb.toString());
        offerItem.setPassengers(passengers);
        FlightInfoAssocType applicableFlight = new FlightInfoAssocType();
        FlightInfoAssocType.Sequence1 sequence = new FlightInfoAssocType.Sequence1();
        FlightReferences flightReferences = new FlightReferences();
        int segmentCounter = 1;
        StringBuilder sb2 = new StringBuilder();
        for (FlightSegmentTariff flightSegmentTariff : flight.getSegmentTariffs()) {
            for (int i = 0; i < flightSegmentTariff.getSegments().size(); ++i) {
                if (sb2.length() > 0) {
                    sb2.append(" ");
                }
                sb2.append("FL".concat(String.valueOf(segmentCounter)));
                ++segmentCounter;
            }
        }
        flightReferences.setString(sb2.toString());
        sequence.setFlightReferences(flightReferences);
        applicableFlight.setSequence(sequence);
        offerItem.setApplicableFlight(applicableFlight);
        offer.getOfferItemList().add(offerItem);
        srot.getOfferList().add(offer);
        request.setQueryOrderItemsShoppingResponse(srot);
        OrderOfferItemType orederOfferItemType = new OrderOfferItemType();
        OfferItemID offerItemID2 = new OfferItemID();
        offerItemID2.setString("UNKNOWN");
        offerItemID2.setOwner(S7NDCHelper.getIataNativeCode(flight.getCarrier()));
        orederOfferItemType.setOfferItemID(offerItemID2);
        OfferItemType offerItemType = new OfferItemType();
        DetailedFlightItem detailedFlightItem = new DetailedFlightItem();
        ArrayList<DetailedFlightItem> listDetailedFlightItem = new ArrayList<DetailedFlightItem>();
        List flightSegments = flight.getSegmentTariffs().stream().flatMap(segmentTariff -> segmentTariff.getSegments().stream()).collect(Collectors.toList());
        List<FlightType> originDestinationList = S7NDCHelper.initializeOriginDestinations(flightSegments, SegmentWrapper::new, null);
        detailedFlightItem.setOriginDestinationList(originDestinationList);
        listDetailedFlightItem.add(detailedFlightItem);
        offerItemType.setDetailedFlightItemList(listDetailedFlightItem);
        orederOfferItemType.setOfferItemType(offerItemType);
        request.getQueryOrderItemsOfferItemList().add(orederOfferItemType);
        if (!StringUtils.isBlank((String)flight.getAccountCode())) {
            DataListType dataLists = new DataListType();
            ListOfOfferInstructionsType instructionsList = new ListOfOfferInstructionsType();
            instructionsList.getInstructionList().add(S7NDCHelper.buildAccountCodeInstruction(flight.getAccountCode()));
            dataLists.setInstructionsList(instructionsList);
            request.setQueryDataLists(dataLists);
        }
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_ACTION, (Object)"Book");
    }
}

