/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.PccHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesOriginContent;
import com.gridnine.xtrip.common.model.booking.SalesOriginProvider;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.BookingReferenceType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderViewRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Passenger;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PassengerSummaryType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerSummaryType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Collection;
import java.util.List;

public class OrderViewRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        OrderViewRS orderViewRS = (OrderViewRS)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Flight flight = parameters.getFlight();
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        reservation.setAccountCode(flight.getAccountCode());
        GDSParameters gdsParameters = (GDSParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.GDS_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        Pcc ticketingPcc = PccHelper.getTicketingPcc((GDSParameters)gdsParameters, (EntityReference)salesContext.getSalesPoint(), (GdsName)GdsName.S7NDC);
        if (ticketingPcc == null) {
            if (PccHelper.getTicketingPccCode((GDSParameters)gdsParameters) == null) {
                throw Xeption.forAdmin((String)"\u0432 \u0442\u043e\u0447\u043a\u0435 \u043f\u0440\u043e\u0434\u0430\u0436 '{0}' \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0432\u044b\u043f\u0438\u0441\u044b\u0432\u0430\u044e\u0449\u0438\u0439 PCC \u0434\u043b\u044f S7 NDC", (Object[])new Object[]{salesContext.getSalesPoint()});
            }
            throw Xeption.forAdmin((String)"\u0432 \u0442\u043e\u0447\u043a\u0435 \u043f\u0440\u043e\u0434\u0430\u0436 '{0}' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d pcc '{1}'", (Object[])new Object[]{salesContext.getSalesPoint(), PccHelper.getTicketingPccCode((GDSParameters)gdsParameters)});
        }
        reservation.setPqTimeLimit(S7NDCHelper.convertTimeLimit(((OrderViewRS.Order)orderViewRS.getOrderList().get(0)).getTimeLimits().getPaymentTimeLimit(), ticketingPcc));
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.S7NDC, (RecordLocatorType)RecordLocatorType.DEFAULT, (String)((BookingReferenceType)((OrderViewRS.Order)orderViewRS.getOrderList().get(0)).getBookingReferences().getBookingReferenceList().get(0)).getID());
        for (GdsTraveller gdsTraveller : parameters.getGdsTravellers()) {
            Traveller traveller = travellers.stream().filter(t -> t.getUid().equals(gdsTraveller.getTravellerUid())).findAny().get();
            Passenger passenger = orderViewRS.getResponsePassengerList().stream().filter(p -> ((PassengerSummaryType.PassengerIDInfo.PassengerDocument)p.getPassengerIDInfo().getPassengerDocumentList().get(0)).getID().equalsIgnoreCase(traveller.getPassport().getNumber())).filter(p -> p.getPTC1().getString().equals(S7NDCHelper.getS7NDCNativeCode(gdsTraveller.getPassengerType()))).filter(p -> p.getNameSurnameString().equalsIgnoreCase(traveller.getPassport().getLastName())).filter(p -> ((TravelerSummaryType.Given)p.getGivenList().get(0)).getString().equalsIgnoreCase(traveller.getPassport().getFirstName())).filter(p -> p.getAge().getBirthDate().equals(new Date(traveller.getPassport().getBirthday().getTime()))).findAny().get();
            Product product = new Product();
            product.setSalesOriginContent(SalesOriginContent.DIRECT_CHANNEL);
            product.setSalesOriginProvider(SalesOriginProvider.DIRECT_CHANNEL);
            String gdsPassengerKey = passenger.getObjectKeyAttrGroup().getObjectKey();
            product.setGdsId(gdsPassengerKey);
            product.setTravellerGdsId(gdsPassengerKey);
            product.setPassengerType(gdsTraveller.getPassengerType());
            product.setReservation(reservation);
            product.setEticket(true);
            product.setCarrier(flight.getCarrier());
            product.setProductCategory(ProductCategory.AIR);
            product.setTariffType(TariffType.REGULAR);
            product.setTraveller(traveller);
            product.setGdsCurrency(flight.getGdsCurrencyCode());
            ProductFare pf = new ProductFare();
            BigDecimal totalFares = flight.getFares().stream().filter(f -> f.getPassengerType().equals((Object)gdsTraveller.getPassengerType())).map(FlightFare::getEquivalentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            pf.setEquivalentFare(totalFares);
            Money money = new Money();
            money.setValue(totalFares);
            money.setCurrency(product.getGdsCurrency());
            pf.setBaseFare(money);
            product.getFares().add(pf);
            for (FlightSegmentTariff flightSegmentTariff : flight.getSegmentTariffs()) {
                SegmentTariff st = new SegmentTariff();
                for (FlightSegment flightSegment : flightSegmentTariff.getSegments()) {
                    FareInfo fareInfo = flightSegment.getFareInfos().stream().filter(fi -> fi.getPassengerType().equals((Object)gdsTraveller.getPassengerType())).findAny().get();
                    Segment segment = new Segment();
                    segment.setGdsId(flightSegment.getGdsId());
                    segment.setFareDetails(fareInfo.getFareDetails());
                    segment.setAirline(flightSegment.getAirline());
                    segment.setArriveLocation(flightSegment.getLocationEnd());
                    segment.setDepartureLocation(flightSegment.getLocationBegin());
                    segment.setEndDate(flightSegment.getDateEnd());
                    segment.setStartDate(flightSegment.getDateBegin());
                    segment.setArriveTerminal(flightSegment.getTerminalEnd());
                    segment.setDepartTerminal(flightSegment.getTerminalBegin());
                    segment.setFlightDuration(Integer.valueOf(flightSegment.getTravelDuration()));
                    segment.setFlightNo(flightSegment.getFlightNumber());
                    segment.setStarting(flightSegment.isStarting());
                    segment.setLuggageInfo(fareInfo.getLuggageInfo());
                    segment.setClassOfSvcCode(flightSegment.getBookingClass());
                    segment.setServiceClass(flightSegment.getServiceClass());
                    segment.setFareBasis(fareInfo.getFareBasis());
                    segment.setAirlineLocator(((BookingReferenceType)((OrderViewRS.Order)orderViewRS.getOrderList().get(0)).getBookingReferences().getBookingReferenceList().get(0)).getID());
                    segment.setCodeShareCarrier(flightSegment.getOperatingAirline());
                    segment.setCodeShareFlightNo(flightSegment.getOperatingFlightNumber());
                    segment.setCodeShare(!segment.getAirline().equals((Object)segment.getCodeShareCarrier()));
                    segment.setBoard(flightSegment.getBoard());
                    segment.setRemarksSearchContext(fareInfo.getRemarksSearchContext());
                    st.getSegments().add(segment);
                }
                product.getSegmentTariffs().add(st);
            }
            OrderViewRSParser.copyTechStopInfo(flight, product);
            for (FlightTax flightTax : flight.getTaxes()) {
                if (!flightTax.getPassengerType().equals((Object)gdsTraveller.getPassengerType())) continue;
                Tax taxKK = new Tax();
                taxKK.setCode(flightTax.getCode());
                taxKK.setEquivalentAmount(flightTax.getEquivalentAmount());
                product.getTaxes().add(taxKK);
            }
            if (flight.getTripartiteContractDetails() != null && flight.getTripartiteContractDetails().isIssuedUnder3d()) {
                product.getTripartiteContractDetails().setIssuedUnder3d(true);
            }
            reservation.getProducts().add(product);
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, (Object)reservation);
    }

    private static void copyTechStopInfo(Flight flight, Product product) {
        List flightSegments = FlightHelper.getSegments((Flight)flight);
        List productSegments = AirProductHelper.getSegments((Collection)product.getSegmentTariffs());
        for (int i = 0; i < flightSegments.size(); ++i) {
            FlightSegment flightSegment = (FlightSegment)flightSegments.get(i);
            Segment productSegment = (Segment)productSegments.get(i);
            if (!productSegment.getTechStopInfos().isEmpty()) continue;
            productSegment.getTechStopInfos().addAll(flightSegment.getTechStopInfos());
        }
    }
}

