/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.createReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsReservationCreationParameters;
import com.gridnine.xtrip.common.gds.model.GdsTraveller;
import com.gridnine.xtrip.common.midoffice.model.BaseAncillaryFee;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class UpdateMcoProductProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        GdsReservationCreationParameters parameters = (GdsReservationCreationParameters)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION_CREATION_PARAMETERS);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        Collection travellers = (Collection)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.TRAVELLERS);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Map<String, String> uid2osiMap = flight.getAncillaryFees().stream().collect(Collectors.toMap(BaseAncillaryFee::getGdsId, S7NDCHelper::getAncillaryFeeOsiCode));
        for (GdsTraveller gdsTraveller : parameters.getGdsTravellers()) {
            if (gdsTraveller.getAncillaryFees().isEmpty()) continue;
            Traveller traveller = (Traveller)CollectionUtil.find((Iterable)travellers, (String)gdsTraveller.getTravellerUid());
            BookingStreamHelper.getProductsStream((Reservation)reservation, Product.class).filter(pr -> pr.getProductCategory() == ProductCategory.MCO).filter(pr -> traveller.equals((Object)pr.getTraveller())).forEach(pr -> {
                String osi = (String)uid2osiMap.get(pr.getGdsId());
                if (TextUtil.isBlank((String)osi)) {
                    throw Xeption.forDeveloper((String)"can't find osi for ancillaryFee with gdsId {0}", (Object[])new Object[]{pr.getGdsId()});
                }
                pr.setGdsId(osi);
            });
        }
    }
}

