/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.getAncillaryFees;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirlineIDType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.DataListObjAttrGroup;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.DataListType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareCode;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareList;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightArrivalType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightDepartureType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightNumber;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.MarketingCarrierFlightType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.SecurePaymentPaxInfoType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.SegmentKey;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServicePriceRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.SrvPriceReqParamsType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Travelers;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.sql.Date;

public class ServicePriceRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        ServicePriceRQ request = new ServicePriceRQ();
        request.setQuery(new ServicePriceRQ.Query());
        DataListType dataList = new DataListType();
        dataList.setFareList(new FareList());
        request.setDataList(dataList);
        FlightType od = null;
        int segIdx = 1;
        for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
            if (fs.isStarting()) {
                od = new FlightType();
                request.getQuery().getOriginDestinationList().add(od);
            }
            FlightType.Flight gdsFlight = new FlightType.Flight();
            SegmentKey segmentKey = new SegmentKey();
            segmentKey.setSegmentKey("SEG".concat(Integer.toString(segIdx)));
            gdsFlight.setSegmentKey(segmentKey);
            FlightDepartureType departure = new FlightDepartureType();
            departure.setAirportCodeString(S7NDCHelper.getIataNativeCode(fs.getLocationBegin()));
            departure.setDate(new Date(fs.getDateBegin().getTime()));
            gdsFlight.setDeparture(departure);
            FlightArrivalType arrival = new FlightArrivalType();
            arrival.setAirportCodeString(S7NDCHelper.getIataNativeCode(fs.getLocationEnd()));
            gdsFlight.setArrival(arrival);
            MarketingCarrierFlightType marketingCarrier = new MarketingCarrierFlightType();
            SecurePaymentPaxInfoType.Carriers.Carrier airlineID = new SecurePaymentPaxInfoType.Carriers.Carrier();
            airlineID.setString(S7NDCHelper.getIataNativeCode(fs.getAirline()));
            marketingCarrier.setAirlineID((AirlineIDType)airlineID);
            FlightNumber flightNumber = new FlightNumber();
            flightNumber.setString(fs.getFlightNumber());
            marketingCarrier.setFlightNumber(flightNumber);
            gdsFlight.setMarketingCarrier(marketingCarrier);
            od.getFlightList().add(gdsFlight);
            FareList.FareGroup fareGroup = new FareList.FareGroup();
            DataListObjAttrGroup attrs = new DataListObjAttrGroup();
            attrs.setRefs("SEG".concat(Integer.toString(segIdx)));
            attrs.setListKey("FG".concat(Integer.toString(segIdx)));
            fareGroup.setDataListObjAttrGroup(attrs);
            FareCode fareFareCode = new FareCode();
            fareFareCode.setCode("ANY");
            fareGroup.setFareFareCode(fareFareCode);
            fareGroup.setFareBasisCodeCode(fs.getFareInfos().stream().filter(f -> f.getPassengerType().equals((Object)DictHelper.getAdultPassengerType())).findAny().get().getFareBasis());
            request.getDataList().getFareList().getFareGroupList().add(fareGroup);
            ++segIdx;
        }
        Travelers travelers = new Travelers();
        for (SeatPreferences sp : flight.getSeats()) {
            Travelers.Traveler traveler = new Travelers.Traveler();
            TravelerCoreType anonymousTraveler = new TravelerCoreType();
            TravelerCoreType.PTC ptc = new TravelerCoreType.PTC();
            ptc.setString(S7NDCHelper.getS7NDCNativeCode(sp.getPassengerType()));
            anonymousTraveler.setPTC1(ptc);
            traveler.setAnonymousTraveler(anonymousTraveler);
            travelers.getTravelerList().add(traveler);
        }
        request.setTravelers(travelers);
        SrvPriceReqParamsType reqParams = new SrvPriceReqParamsType();
        reqParams.setServiceFilters(S7NDCHelper.buildBaggageServiceFilters());
        request.setParameters(reqParams);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_ACTION, (Object)"ServicePrice");
    }
}

