/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.getAncillaryFees;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.helper.GdsDictHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFee;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.gds.s7ndc.S7NDCGdsAccount;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.v052.ServicePriceRSHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfFlightSegmentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OriginDestination;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServiceCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServicePriceRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServicePriceType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ServicePriceRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        ServicePriceRS response = (ServicePriceRS)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
        flight.setAncillaryFeesRequestNeeded(false);
        Set seatsPassengerTypes = GDSHelper.getPassengerTypes((List)flight.getSeats());
        seatsPassengerTypes.removeIf(DictHelper::isInfantPassengerTypeCategory);
        Map<String, OriginDestination> odDataList = ServicePriceRSHelper.getOdDataList(response);
        Map<String, ListOfFlightSegmentType> segDataList = ServicePriceRSHelper.getSegDataList(response);
        Map<String, TravelerCoreType> shDataList = ServicePriceRSHelper.getShDataList(response);
        if (response.getServices() != null && response.getServices().getServiceList() != null) {
            response.getServices().getServiceList().stream().filter(s -> !BigDecimal.ZERO.equals(((ServicePriceType)s.getPriceList().get(0)).getTotal().getDecimal())).forEach(service -> {
                Set pts = ServicePriceRSHelper.getPassengerTypeCodes((ServiceCoreType)service, shDataList).stream().map(pt -> S7NDCHelper.resolveS7NDCNativeCode(PassengerType.class, pt)).collect(Collectors.toSet());
                if (pts.isEmpty()) {
                    pts = seatsPassengerTypes;
                }
                for (DictionaryReference pt2 : pts) {
                    AncillaryFee af = new AncillaryFee();
                    af.setGdsDescription(service.getDescriptions().getDescriptionList().stream().filter(d -> d.getObjectKeyMetaAttrGroup().getObjectKey().startsWith("description_")).findAny().get().getText().getString());
                    af.setType(ServicePriceRSParser.parseType(service.getName()));
                    af.setDescription((DictionaryReference)Optional.ofNullable(GdsDictHelper.findAncillaryFeeDescriptionByServiceName((AncillaryFeeType)af.getType(), (String)af.getGdsDescription(), (GdsName)((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getGds())).map(AncillaryFeeDescription::toReference).orElse(null));
                    BigDecimal fare = ((ServicePriceType)service.getPriceList().get(0)).getTotal().getDecimal();
                    af.setBaseAmount(MoneyHelper.buildMoney((BigDecimal)fare, (String)((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getCurrency().getCode()));
                    af.setEquivalentAmount(fare);
                    af.setPassengerType(pt2);
                    String osi = (String)service.getBookingInstructions().getOSITextList().get(0);
                    S7NDCHelper.setAncillaryFeeOsiCode(af, osi);
                    List flightSegments = FlightHelper.getSegments((Flight)flight);
                    af.getSegmentNumbers().addAll(ServicePriceRSHelper.getSegmentNumbers((ServiceCoreType)service, flightSegments, ServicePriceRSParser::getFlightSegmentIndex, odDataList, segDataList));
                    af.setGdsId(af.getUid());
                    boolean yetExists = flight.getAncillaryFees().stream().anyMatch(faf -> ServicePriceRSParser.isSameAncillaryFees(faf, af));
                    if (yetExists) continue;
                    flight.getAncillaryFees().add(af);
                }
            });
        }
    }

    private static int getFlightSegmentIndex(List<FlightSegment> flightSegments, ListOfFlightSegmentType gdsFs) {
        for (int i = 0; i < flightSegments.size(); ++i) {
            FlightSegment fs = flightSegments.get(i);
            if (!Objects.equals(gdsFs.getMarketingCarrier().getAirlineID().getString(), S7NDCHelper.getIataNativeCode(fs.getAirline())) || !Objects.equals(gdsFs.getMarketingCarrier().getFlightNumber().getString(), fs.getFlightNumber()) || !Objects.equals(MiscUtil.clearTime((Date)gdsFs.getDeparture().getDate()), MiscUtil.clearTime((Date)fs.getDateBegin()))) continue;
            return i;
        }
        throw Xeption.forDeveloper((String)String.format("segment not found %s %s %s", gdsFs.getMarketingCarrier().getAirlineID().getString(), gdsFs.getMarketingCarrier().getFlightNumber().getString(), gdsFs.getDeparture().getDate()), (Object[])new Object[0]);
    }

    private static AncillaryFeeType parseType(String name) {
        switch (name) {
            case "bag": {
                return AncillaryFeeType.BAGGAGE;
            }
            case "special": 
            case "pet": {
                return AncillaryFeeType.PETS;
            }
            case "meal": {
                return AncillaryFeeType.MEALS;
            }
            case "seat": {
                return AncillaryFeeType.PREFERRED_SEATING;
            }
            case "upgrade": {
                return AncillaryFeeType.UPGRADES;
            }
            case "lounge": {
                return AncillaryFeeType.LOUNGE;
            }
        }
        throw Xeption.forDeveloper((String)("unexpected name " + name), (Object[])new Object[0]);
    }

    private static boolean isSameAncillaryFees(AncillaryFee af1, AncillaryFee af2) {
        String osi2;
        if (af1 == null || af2 == null) {
            return false;
        }
        String osi1 = S7NDCHelper.getAncillaryFeeOsiCode(af1);
        if (!MiscUtil.equals((Object)osi1, (Object)(osi2 = S7NDCHelper.getAncillaryFeeOsiCode(af2)))) {
            return false;
        }
        if (!MiscUtil.equals((Object)af1.getPassengerType(), (Object)af2.getPassengerType())) {
            return false;
        }
        return CollectionUtil.sameElements((Collection)af1.getSegmentNumbers(), (Collection)af2.getSegmentNumbers());
    }
}

