/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.getFareRules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirlineIDType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareQualifierType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightArrivalType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightCOSCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightDepartureType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightPriceRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FltPriceReqParamsType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Qualifiers;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServiceFilterType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Travelers;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FlightPriceRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        String passengerTypeCode = (String)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FARE_REMARKS_SEARCH_CONTEXT);
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        Reservation reservation = (Reservation)ctx.getObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_REQUEST_PAYLOAD, (Object)this.createFlightInfoRQ(reservation, flight, passengerTypeCode));
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_ACTION, (Object)"FlightInfo");
    }

    private FlightPriceRQ createFlightInfoRQ(Reservation reservation, Flight flight, String passengerTypeCode) {
        String accountCode;
        FlightPriceRQ request = new FlightPriceRQ();
        FltPriceReqParamsType parameters = new FltPriceReqParamsType();
        FltPriceReqParamsType.ServiceFilters serviceFilters = new FltPriceReqParamsType.ServiceFilters();
        ServiceFilterType serviceFilter = new ServiceFilterType();
        serviceFilter.setGroupCode("FareRules");
        serviceFilter.getSubGroupCodeList().add("true");
        serviceFilters.getServiceFilterList().add(serviceFilter);
        parameters.setServiceFilters(serviceFilters);
        request.setParameters(parameters);
        Travelers travelers = new Travelers();
        Travelers.Traveler traveler = new Travelers.Traveler();
        TravelerCoreType anonymousTraveler = new TravelerCoreType();
        TravelerCoreType.PTC ptc = new TravelerCoreType.PTC();
        ptc.setQuantity(BigInteger.ONE);
        ptc.setString(passengerTypeCode);
        anonymousTraveler.setPTC1(ptc);
        traveler.setAnonymousTraveler(anonymousTraveler);
        travelers.getTravelerList().add(traveler);
        request.setTravelers(travelers);
        request.setQueryList(new ArrayList());
        if (reservation != null) {
            request.getQueryList().addAll(this.buildQueries(AirProductHelper.getAirProductsStream((Reservation)reservation).filter(prod -> passengerTypeCode.equals(S7NDCHelper.getS7NDCNativeCode(prod.getPassengerType()))).findAny().get()));
        } else {
            request.getQueryList().addAll(this.buildQueries(flight, passengerTypeCode));
        }
        String string = accountCode = flight != null ? flight.getAccountCode() : reservation.getAccountCode();
        if (!StringUtils.isBlank((String)accountCode)) {
            String[] accountCodeParts = accountCode.split("/");
            Qualifiers qualifiers = new Qualifiers();
            Qualifiers.Qualifier qualifier = new Qualifiers.Qualifier();
            FareQualifierType specialFareQualifiers = new FareQualifierType();
            AirlineIDType airlineID = new AirlineIDType();
            airlineID.setString("S7");
            specialFareQualifiers.setAirlineID(airlineID);
            FareQualifierType.CompanyIndex companyIndex = new FareQualifierType.CompanyIndex();
            companyIndex.setString(accountCodeParts[0]);
            specialFareQualifiers.setCompanyIndex(companyIndex);
            FareQualifierType.Account account = new FareQualifierType.Account();
            account.setString(accountCodeParts[1]);
            specialFareQualifiers.setAccount(account);
            qualifier.setSpecialFareQualifiers(specialFareQualifiers);
            qualifiers.getQualifierList().add(qualifier);
            request.setQualifiers(qualifiers);
        }
        return request;
    }

    private List<FlightType> buildQueries(Product product) {
        ArrayList<FlightType> result = new ArrayList<FlightType>();
        FlightType query = null;
        for (Segment seg : AirProductHelper.getSegments((Collection)product.getSegmentTariffs())) {
            if (seg.isStarting()) {
                if (query != null) {
                    result.add(query);
                }
                query = new FlightType();
            }
            FlightType.Flight fl = new FlightType.Flight();
            FlightDepartureType departure = new FlightDepartureType();
            departure.setAirportCodeString(S7NDCHelper.getIataNativeCode(seg.getDepartureLocation()));
            departure.setDate(new Date(seg.getStartDate().getTime()));
            fl.setDeparture(departure);
            FlightArrivalType arrival = new FlightArrivalType();
            arrival.setAirportCodeString(S7NDCHelper.getIataNativeCode(seg.getArriveLocation()));
            fl.setArrival(arrival);
            fl.setMarketingCarrier(S7NDCHelper.buildMarketingCarrierFlightType((DictionaryReference<Airline>)seg.getAirline(), seg.getFlightNo()));
            FlightCOSCoreType classOfService = new FlightCOSCoreType();
            classOfService.setCodeString(seg.getClassOfSvcCode());
            FlightCOSCoreType.MarketingName marketingName = new FlightCOSCoreType.MarketingName();
            marketingName.setString(S7NDCHelper.extractFareBasisCode(seg.getFareBasis()));
            classOfService.setMarketingName(marketingName);
            fl.setClassOfService(classOfService);
            query.getFlightList().add(fl);
        }
        result.add(query);
        return result;
    }

    private List<FlightType> buildQueries(Flight flight, String passengerTypeCode) {
        ArrayList<FlightType> result = new ArrayList<FlightType>();
        FlightType query = null;
        for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
            if (fs.isStarting()) {
                if (query != null) {
                    result.add(query);
                }
                query = new FlightType();
            }
            FlightType.Flight fl = new FlightType.Flight();
            FlightDepartureType departure = new FlightDepartureType();
            departure.setAirportCodeString(S7NDCHelper.getIataNativeCode(fs.getLocationBegin()));
            departure.setDate(new Date(fs.getDateBegin().getTime()));
            fl.setDeparture(departure);
            FlightArrivalType arrival = new FlightArrivalType();
            arrival.setAirportCodeString(S7NDCHelper.getIataNativeCode(fs.getLocationEnd()));
            fl.setArrival(arrival);
            fl.setMarketingCarrier(S7NDCHelper.buildMarketingCarrierFlightType((DictionaryReference<Airline>)fs.getAirline(), fs.getFlightNumber()));
            FlightCOSCoreType classOfService = new FlightCOSCoreType();
            classOfService.setCodeString(fs.getBookingClass());
            FlightCOSCoreType.MarketingName marketingName = new FlightCOSCoreType.MarketingName();
            String fareBasis = fs.getFareInfos().stream().filter(fi -> S7NDCHelper.getS7NDCNativeCode(fi.getPassengerType()).equals(passengerTypeCode)).findAny().get().getFareBasis();
            marketingName.setString(S7NDCHelper.extractFareBasisCode(fareBasis));
            classOfService.setMarketingName(marketingName);
            fl.setClassOfService(classOfService);
            query.getFlightList().add(fl);
        }
        result.add(query);
        return result;
    }
}

