/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.invoke;

import com.gridnine.xtrip.common.gds.exceptions.SeatsNotConfirmedException;
import com.gridnine.xtrip.common.gds.s7ndc.exceptions.AutomaticPricingImpossibleException;
import com.gridnine.xtrip.common.gds.s7ndc.exceptions.BookingWasCancelledException;
import com.gridnine.xtrip.common.gds.s7ndc.exceptions.OptionsAreEmptyException;
import com.gridnine.xtrip.common.gds.s7ndc.exceptions.UsePaxSelectionException;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.util.ObjectTrace;
import com.gridnine.xtrip.common.util.Predicates;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.v052.invoke.S7NDCErrorWrapper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirDocDisplayRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirDocVoidRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirShoppingRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ErrorsType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightPriceRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ItinReshopRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderCancelRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderViewRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServicePriceRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs.IATAOrderViewRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs.IATAOrderListRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs.IATAOrderReshopRS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class S7NDCErrorsTranslator
extends BaseProcessor {
    private static final Map<Predicate<S7NDCErrorWrapper>, Class<? extends Exception>> CUSTOM_EXCEPTIONS = new HashMap<Predicate<S7NDCErrorWrapper>, Class<? extends Exception>>();
    private static final Map<Predicate<S7NDCErrorWrapper>, Xeption> TRANSLATIONS;

    public void process(MessageContext ctx) throws Exception {
        try {
            Object response = ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
            S7NDCErrorsTranslator.checkErrors(response);
        }
        finally {
            ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_REQUEST_PAYLOAD, null);
        }
    }

    private static Predicate<S7NDCErrorWrapper> textMatches(final String pattern) {
        return new Predicate<S7NDCErrorWrapper>(){
            private final Pattern P;
            {
                this.P = Pattern.compile(pattern);
            }

            @Override
            public boolean test(S7NDCErrorWrapper error) {
                String text = error.getText();
                return text != null && this.P.matcher(text).matches();
            }
        };
    }

    private static Predicate<S7NDCErrorWrapper> textEquals(String value) {
        return error -> value.equals(error.getText());
    }

    private static Predicate<S7NDCErrorWrapper> textContains(String value) {
        return error -> error.getText() != null && error.getText().contains(value);
    }

    private static Predicate<S7NDCErrorWrapper> textIsNull() {
        return error -> error.getText() == null;
    }

    private static Predicate<S7NDCErrorWrapper> codeEquals(String value) {
        return error -> value.equals(error.getCode());
    }

    private static Predicate<S7NDCErrorWrapper> tagEquals(String value) {
        return error -> value.equals(error.getTag());
    }

    private static void checkErrors(Object response) throws Exception {
        List<S7NDCErrorWrapper> errors = S7NDCErrorsTranslator.getErrors(response);
        if (errors.isEmpty()) {
            return;
        }
        S7NDCErrorsTranslator.checkTypedErrors(errors, response);
        for (S7NDCErrorWrapper error : errors) {
            for (Map.Entry<Predicate<S7NDCErrorWrapper>, Class<? extends Exception>> entry : CUSTOM_EXCEPTIONS.entrySet()) {
                if (!entry.getKey().test(error)) continue;
                throw entry.getValue().newInstance();
            }
        }
        for (S7NDCErrorWrapper error : errors) {
            for (Map.Entry<Predicate<S7NDCErrorWrapper>, Class<? extends Exception>> entry : TRANSLATIONS.entrySet()) {
                if (!entry.getKey().test(error)) continue;
                throw (Xeption)entry.getValue();
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Object error : errors.stream().map(S7NDCErrorWrapper::getOriginalError).collect(Collectors.toList())) {
            ObjectTrace.trace((Appendable)sb, error);
        }
        throw Xeption.forDeveloper((String)sb.toString(), (Object[])new Object[0]);
    }

    private static void checkTypedErrors(List<S7NDCErrorWrapper> errors, Object response) {
        if (response instanceof FlightPriceRS) {
            for (S7NDCErrorWrapper error : errors) {
                if (!"ITA doesn't provide list of search flights".equals(error.getText())) continue;
                throw Xeption.forEndUser((String)Messages.forRequestRulesToTheCallCenter, (Object[])new Object[0]);
            }
        }
    }

    private static List<S7NDCErrorWrapper> getErrors(Object response) {
        ErrorsType errors;
        if (response instanceof AirShoppingRS) {
            AirShoppingRS typedResponse = (AirShoppingRS)response;
            errors = typedResponse.getErrors();
        } else if (response instanceof FlightPriceRS) {
            FlightPriceRS typedResponse = (FlightPriceRS)response;
            errors = typedResponse.getErrors();
        } else if (response instanceof OrderViewRS) {
            OrderViewRS typedResponse = (OrderViewRS)response;
            errors = typedResponse.getErrors();
        } else if (response instanceof ItinReshopRS) {
            ItinReshopRS typedResponse = (ItinReshopRS)response;
            errors = typedResponse.getErrors();
        } else if (response instanceof AirDocDisplayRS) {
            AirDocDisplayRS typedResponse = (AirDocDisplayRS)response;
            errors = typedResponse.getErrors();
        } else if (response instanceof OrderCancelRS) {
            OrderCancelRS typedResponse = (OrderCancelRS)response;
            errors = typedResponse.getErrors();
        } else if (response instanceof AirDocVoidRS) {
            AirDocVoidRS typedResponse = (AirDocVoidRS)response;
            errors = typedResponse.getErrors();
        } else if (response instanceof ServicePriceRS) {
            ServicePriceRS typedResponse = (ServicePriceRS)response;
            errors = typedResponse.getErrors();
        } else {
            if (response instanceof IATAOrderReshopRS) {
                IATAOrderReshopRS typedResponse = (IATAOrderReshopRS)response;
                return Optional.ofNullable(typedResponse.getErrorList()).orElse(Collections.emptyList()).stream().map(S7NDCErrorWrapper::new).collect(Collectors.toList());
            }
            if (response instanceof IATAOrderViewRS) {
                IATAOrderViewRS typedResponse = (IATAOrderViewRS)response;
                return Optional.ofNullable(typedResponse.getErrorList()).orElse(Collections.emptyList()).stream().map(S7NDCErrorWrapper::new).collect(Collectors.toList());
            }
            if (response instanceof IATAOrderListRS) {
                IATAOrderListRS typedResponse = (IATAOrderListRS)response;
                return Optional.ofNullable(typedResponse.getErrorList()).orElse(Collections.emptyList()).stream().map(S7NDCErrorWrapper::new).collect(Collectors.toList());
            }
            throw Xeption.forDeveloper((String)"unexpected response class {0}", (Object[])new Object[]{response.getClass().getName()});
        }
        if (errors != null) {
            if (errors.getErrorList() == null) {
                throw Xeption.forEndUser((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0415\u0441\u043b\u0438 \u0412\u044b \u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u0442\u044c \u0431\u0438\u043b\u0435\u0442 \u0438\u043b\u0438 \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437, \u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]);
            }
            return errors.getErrorList().stream().map(S7NDCErrorWrapper::new).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    static {
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.textMatches("NN[0-9] UNABLE"), SeatsNotConfirmedException.class);
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.textMatches("[A-Z]{6} UNABLE"), SeatsNotConfirmedException.class);
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.textEquals("NOT AVAILABLE BUT WAITLIST OPEN"), SeatsNotConfirmedException.class);
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.textEquals("NOT AVAILABLE AND WAITLIST CLOSED"), SeatsNotConfirmedException.class);
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.textEquals("*NO FARES/RBD/CARRIER/PASSENGER TYPE"), SeatsNotConfirmedException.class);
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.textEquals("Booking was cancelled"), BookingWasCancelledException.class);
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.textEquals("TOO MANY PASSENGERS - USE PAX SELECTION"), UsePaxSelectionException.class);
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.textEquals("options.are.empty"), OptionsAreEmptyException.class);
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.codeEquals("nn.unable.error"), SeatsNotConfirmedException.class);
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.codeEquals("amadeus.error.251"), SeatsNotConfirmedException.class);
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.codeEquals("amadeus.error.segment.waitlist.error"), SeatsNotConfirmedException.class);
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.codeEquals("\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0442\u0430\u0440\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430"), AutomaticPricingImpossibleException.class);
        CUSTOM_EXCEPTIONS.put(S7NDCErrorsTranslator.tagEquals("Unfortunately your booking cannot be completed because chosen tickets were sold. Please use Search again to choose tickets."), SeatsNotConfirmedException.class);
        TRANSLATIONS = new HashMap<Predicate<S7NDCErrorWrapper>, Xeption>();
        TRANSLATIONS.put(S7NDCErrorsTranslator.textEquals("Service is not available. Pls try later"), Xeption.forEndUser((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0415\u0441\u043b\u0438 \u0412\u044b \u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u0442\u044c \u0431\u0438\u043b\u0435\u0442 \u0438\u043b\u0438 \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437, \u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]));
        TRANSLATIONS.put(S7NDCErrorsTranslator.textEquals("Service is not available. Please try again in 30 seconds."), Xeption.forEndUser((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0430/\u043a . \u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0435 \u0437\u0430\u043f\u0440\u043e\u0441 \u0447\u0435\u0440\u0435\u0437 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043c\u0438\u043d\u0443\u0442", (Object[])new Object[0]));
        TRANSLATIONS.put(S7NDCErrorsTranslator.textContains("NO FARES/RBD/CARRIER/PASSENGER TYPE"), Xeption.forEndUser((String)"\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430. \u0417\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435\u043c/\u0432\u044b\u043f\u0438\u0441\u043a\u043e\u0439 \u0430\u0432\u0438\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440", (Object[])new Object[0]));
        TRANSLATIONS.put(S7NDCErrorsTranslator.textEquals("LINK DOWN"), Xeption.forEndUser((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0415\u0441\u043b\u0438 \u0412\u044b \u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u0442\u044c \u0431\u0438\u043b\u0435\u0442 \u0438\u043b\u0438 \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437, \u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]));
        TRANSLATIONS.put(S7NDCErrorsTranslator.textEquals("S7 ETKT: MAXIMUM TICKET LIMIT REACHED"), Xeption.forAdmin((String)"\u0418\u0441\u0447\u0435\u0440\u043f\u0430\u043d \u043b\u0438\u043c\u0438\u0442 \u0434\u043b\u044f \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u0441\u0442\u043e\u043a\u0430. \u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u0430/\u043a \u0437\u0430 \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435\u043c", (Object[])new Object[0]));
        TRANSLATIONS.put(S7NDCErrorsTranslator.textEquals("INVALID ACTION CODE"), Xeption.forEndUser((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0415\u0441\u043b\u0438 \u0412\u044b \u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u0442\u044c \u0431\u0438\u043b\u0435\u0442 \u0438\u043b\u0438 \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437, \u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]));
        TRANSLATIONS.put(S7NDCErrorsTranslator.textEquals("Order not found"), Xeption.forEndUser((String)"\u041c\u0435\u0441\u0442\u0430 \u043d\u0430 \u043e\u0434\u043d\u043e\u043c \u0438\u0437 \u0440\u0435\u0439\u0441\u043e\u0432 \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u044b \u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0435\u0439. \u0414\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u044b \u0437\u0430\u043a\u0430\u0437\u0430 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440.", (Object[])new Object[0]));
        TRANSLATIONS.put(Predicates.and((Predicate[])new Predicate[]{S7NDCErrorsTranslator.codeEquals("internal.service.error"), S7NDCErrorsTranslator.textIsNull(), S7NDCErrorsTranslator.tagEquals("At this time, we are unable to perform this action, please try again later, or let us know about the issue")}), Xeption.forEndUser((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0415\u0441\u043b\u0438 \u0412\u044b \u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u0442\u044c \u0431\u0438\u043b\u0435\u0442 \u0438\u043b\u0438 \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437, \u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]));
        TRANSLATIONS.put(Predicates.and((Predicate[])new Predicate[]{S7NDCErrorsTranslator.codeEquals("add.book.fare.failed"), S7NDCErrorsTranslator.tagEquals("Unfortunately your booking can not be completed. Please try one more time or call our customer service center or please use our feedback form.")}), Xeption.forEndUser((String)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438 \u0431\u0438\u043b\u0435\u0442\u0430, \u043f\u0440\u043e\u0441\u044c\u0431\u0430 \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e", (Object[])new Object[0]));
    }
}

