/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.invoke;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.gds.s7ndc.S7NDCGdsAccount;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonCommunication;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.v052.invoke.S7NDCRequestParams;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AgencyCoreRepType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AgentUserSender;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirDocDisplayRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirDocIssueRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirDocVoidRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirShoppingRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Contacts;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightPriceRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.IATAPayloadStdAttributes;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ItinReshopRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.MsgDocumentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.MsgPartiesType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderCancelRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderChangeRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderCreateRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderRetrieveRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PhoneContact;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PhoneType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServicePriceRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.UniqueIDContextType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq.IATAOrderChangeRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq.PartyType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq.SenderType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs.IATAOrderViewRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq.IATAOrderListRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs.IATAOrderListRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq.IATAOrderReshopRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq.TravelAgencyType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs.IATAOrderReshopRS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.ContentEncoding;
import com.gridnine.xtrip.server.jibxws.IBusJibxWsContextKeys;
import com.gridnine.xtrip.server.jibxws.WsRequest;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jibx.ws.http.client.Basic;
import org.jibx.ws.http.client.Credentials;

public class S7NDCWSRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Integer requestTimeOut;
        Object request = ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_REQUEST_PAYLOAD);
        String action = (String)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_ACTION);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        SalesContext salesContext = (SalesContext)ctx.getObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        this.populateRequest(request, (S7NDCGdsAccount)gdsAccountCtr.getEntity(), salesContext);
        WsRequest wsRequest = new WsRequest();
        wsRequest.setAcceptEncoding(EnumSet.of(ContentEncoding.GZIP, ContentEncoding.DEFLATE));
        wsRequest.setAcceptTypes(new String[0]);
        wsRequest.setPayload(request);
        wsRequest.setCredentials((Credentials)new Basic(((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getBasicAuthUsername(), ((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getBasicAuthPassword() != null ? ((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getBasicAuthPassword().toCharArray() : null));
        wsRequest.addHttpHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])(((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getBasicAuthUsername() + ":" + ((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getBasicAuthPassword()).getBytes()));
        wsRequest.setHttpHeader("X-API-Version", "0.52");
        wsRequest.setEndpointAddress(((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getEndpointUrl());
        wsRequest.setAction(String.format("http://api.s7.ru/%s", action));
        wsRequest.setKeyStore(((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getCertificate(), "jks", ((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getCertificatePassword().toCharArray());
        S7NDCRequestParams requestParams = (S7NDCRequestParams)ctx.getObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_REQUEST_PARAMETERS);
        if (requestParams != null && (requestTimeOut = requestParams.getVoidRequestTimeOut()) != null) {
            wsRequest.setConnectionTimeout(requestTimeOut);
            wsRequest.setReadTimeout(requestTimeOut);
        }
        wsRequest.setSeparateBodyResponseClass(this.getSeparateBodyResponseClass(request));
        ctx.putObject((Enum)IBusJibxWsContextKeys.WS_REQUEST, (Object)wsRequest);
    }

    private void populateRequest(Object request, S7NDCGdsAccount account, SalesContext salesContext) {
        IATAPayloadStdAttributes iataPayloadStdAttributes = this.createIATAPayloadStdAttributes();
        MsgDocumentType document = this.createDocument();
        MsgPartiesType party = this.createParty(account);
        if (request instanceof AirShoppingRQ) {
            AirShoppingRQ typedRequest = (AirShoppingRQ)request;
            typedRequest.setIATAPayloadStdAttributes(iataPayloadStdAttributes);
            typedRequest.setDocument(document);
            typedRequest.setParty(party);
        } else if (request instanceof FlightPriceRQ) {
            FlightPriceRQ typedRequest = (FlightPriceRQ)request;
            typedRequest.setIATAPayloadStdAttributes(iataPayloadStdAttributes);
            typedRequest.setDocument(document);
            typedRequest.setParty(party);
        } else if (request instanceof OrderCreateRQ) {
            OrderCreateRQ typedRequest = (OrderCreateRQ)request;
            typedRequest.setIATAPayloadStdAttributes(iataPayloadStdAttributes);
            typedRequest.setDocument(document);
            party.getSenderAgentUserSender().setContacts(S7NDCWSRequestBuilder.buildContacts(salesContext));
            typedRequest.setParty(party);
        } else if (request instanceof ItinReshopRQ) {
            ItinReshopRQ typedRequest = (ItinReshopRQ)request;
            typedRequest.setIATAPayloadStdAttributes(iataPayloadStdAttributes);
            typedRequest.setDocument(document);
            typedRequest.setParty(party);
        } else if (request instanceof OrderCancelRQ) {
            OrderCancelRQ typedRequest = (OrderCancelRQ)request;
            typedRequest.setIATAPayloadStdAttributes(iataPayloadStdAttributes);
            typedRequest.setDocument(document);
            typedRequest.setParty(party);
        } else if (request instanceof AirDocIssueRQ) {
            AirDocIssueRQ typedRequest = (AirDocIssueRQ)request;
            typedRequest.setIATAPayloadStdAttributes(iataPayloadStdAttributes);
            typedRequest.setDocument(document);
            typedRequest.setParty(party);
        } else if (request instanceof AirDocVoidRQ) {
            AirDocVoidRQ typedRequest = (AirDocVoidRQ)request;
            typedRequest.setIATAPayloadStdAttributes(iataPayloadStdAttributes);
            typedRequest.setDocument(document);
            typedRequest.setParty(party);
        } else if (request instanceof OrderRetrieveRQ) {
            OrderRetrieveRQ typedRequest = (OrderRetrieveRQ)request;
            typedRequest.setIATAPayloadStdAttributes(iataPayloadStdAttributes);
            typedRequest.setDocument(document);
            typedRequest.setParty(party);
        } else if (request instanceof AirDocDisplayRQ) {
            AirDocDisplayRQ typedRequest = (AirDocDisplayRQ)request;
            typedRequest.setIATAPayloadStdAttributes(iataPayloadStdAttributes);
            typedRequest.setDocument(document);
            typedRequest.setParty(party);
        } else if (request instanceof ServicePriceRQ) {
            ServicePriceRQ typedRequest = (ServicePriceRQ)request;
            typedRequest.setIATAPayloadStdAttributes(iataPayloadStdAttributes);
            typedRequest.setDocument(document);
            typedRequest.setParty(party);
        } else if (request instanceof OrderChangeRQ) {
            OrderChangeRQ typedRequest = (OrderChangeRQ)request;
            typedRequest.setDocument(document);
            typedRequest.setParty(party);
        } else if (request instanceof IATAOrderReshopRQ) {
            IATAOrderReshopRQ typedRequest = (IATAOrderReshopRQ)request;
            typedRequest.setParty(this.createIATAOrderReshopParty(account));
        } else if (request instanceof IATAOrderChangeRQ) {
            IATAOrderChangeRQ typedRequest = (IATAOrderChangeRQ)request;
            typedRequest.setParty(this.createIATAOrderChangeParty(account));
        } else if (request instanceof IATAOrderListRQ) {
            IATAOrderListRQ typedRequest = (IATAOrderListRQ)request;
            typedRequest.setParty(this.createIATAOrderListParty(account));
        } else {
            throw Xeption.forDeveloper((String)"unexpected request class {0}", (Object[])new Object[]{request.getClass().getName()});
        }
    }

    private static String getAgencyName(EntityContainer<Organization> orgCtr) {
        String result = TextUtil.translit((String)L10nStringHelper.getEnglishValue((L10nString)((Organization)orgCtr.getEntity()).getShortName()), (boolean)true);
        if (result == null) {
            result = TextUtil.translit((String)L10nStringHelper.getEnglishValue((L10nString)((Organization)orgCtr.getEntity()).getFullName()), (boolean)true);
        }
        char[] chars = result.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] >= 'A' && chars[i] <= 'Z' || chars[i] >= 'a' && chars[i] <= 'z' || chars[i] >= '0' && chars[i] <= '9') continue;
            chars[i] = 32;
        }
        result = new String(chars).trim();
        if (result.length() > 50) {
            result = result.substring(0, 50);
        }
        return result;
    }

    private static Contacts buildContacts(SalesContext salesContext) {
        if (salesContext == null) {
            throw Xeption.forDeveloper((String)"salesContext is missing", (Object[])new Object[0]);
        }
        Person agent = (Person)EntityStorage.get().resolve(salesContext.getAgent()).getEntity();
        EntityContainer orgCtr = ProfileHelper.getMainEmployment((Person)agent);
        Communication comm = S7NDCWSRequestBuilder.getCommunication((Organization)orgCtr.getEntity(), agent);
        Contacts contacts = new Contacts();
        Contacts.Contact contact = new Contacts.Contact();
        PhoneContact phoneContact = new PhoneContact();
        phoneContact.setApplication(S7NDCWSRequestBuilder.getAgencyName((EntityContainer<Organization>)orgCtr));
        PhoneType._Number number = new PhoneType._Number();
        number.setCountryCode(ProfileHelper.normalizeCommunicationPart((String)comm.getCountryCode()));
        number.setAreaCode(ProfileHelper.normalizeCommunicationPart((String)comm.getCityCode()));
        number.setString(ProfileHelper.normalizeCommunicationPart((String)comm.getSense()));
        phoneContact.getNumberList().add(number);
        contact.setPhoneContact(phoneContact);
        contacts.getContactList().add(contact);
        return contacts;
    }

    private static Communication getCommunication(Organization org, Person agent) {
        Optional<Communication> orgWorkPhone = org.getCommunications().stream().filter(c -> c.getType() == CommunicationType.WORK_PHONE).findFirst();
        if (orgWorkPhone.isPresent()) {
            return orgWorkPhone.get();
        }
        Collection orgAllPhones = ProfileHelper.getPhoneCommunications((List)org.getCommunications());
        if (!orgAllPhones.isEmpty()) {
            return (Communication)orgAllPhones.iterator().next();
        }
        Optional<PersonCommunication> agtWorkPhone = agent.getCommunications().stream().filter(c -> c.getType() == CommunicationType.WORK_PHONE).findFirst();
        if (agtWorkPhone.isPresent()) {
            return (Communication)agtWorkPhone.get();
        }
        Collection agtAllPhones = ProfileHelper.getPhoneCommunications((List)agent.getCommunications());
        if (!agtAllPhones.isEmpty()) {
            return (Communication)agtAllPhones.iterator().next();
        }
        throw Xeption.forAdmin((String)"\u0412 \u043f\u0440\u043e\u0444\u0438\u043b\u0435 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 '{0}' \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u043e\u043c\u0435\u0440 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0430", (Object[])new Object[]{org.getFullName()});
    }

    private IATAPayloadStdAttributes createIATAPayloadStdAttributes() {
        IATAPayloadStdAttributes iataPayloadStdAttributes = new IATAPayloadStdAttributes();
        iataPayloadStdAttributes.setVersion("1.0");
        return iataPayloadStdAttributes;
    }

    private MsgDocumentType createDocument() {
        MsgDocumentType document = new MsgDocumentType();
        document.setName("1.0");
        return document;
    }

    private MsgPartiesType createParty(S7NDCGdsAccount gdsAccount) {
        MsgPartiesType party = new MsgPartiesType();
        AgentUserSender agentUserSender = new AgentUserSender();
        agentUserSender.setName(gdsAccount.getAgentUserSenderName());
        AgencyCoreRepType.OtherIDs otherIDs = new AgencyCoreRepType.OtherIDs();
        otherIDs.getOtherIDList().add(this.createOtherID("POS_Type", "1"));
        otherIDs.getOtherIDList().add(this.createOtherID("requestorType", "U"));
        if (!StringUtils.isBlank((String)gdsAccount.getOtherIdPassword())) {
            otherIDs.getOtherIDList().add(this.createOtherID("Password", gdsAccount.getOtherIdPassword()));
        }
        agentUserSender.setOtherIDs(otherIDs);
        AgencyCoreRepType.PseudoCity pseudoCity = new AgencyCoreRepType.PseudoCity();
        pseudoCity.setString(gdsAccount.getPseudoCity());
        agentUserSender.setPseudoCity(pseudoCity);
        UniqueIDContextType agentUserID = new UniqueIDContextType();
        agentUserID.setString(gdsAccount.getAgentUserID());
        agentUserSender.setAgentUserID(agentUserID);
        agentUserSender.setUserRole(gdsAccount.getUserRole());
        party.setSenderAgentUserSender(agentUserSender);
        return party;
    }

    private Class getSeparateBodyResponseClass(Object request) {
        if (request instanceof IATAOrderReshopRQ) {
            return IATAOrderReshopRS.class;
        }
        if (request instanceof IATAOrderChangeRQ) {
            return IATAOrderViewRS.class;
        }
        if (request instanceof IATAOrderListRQ) {
            return IATAOrderListRS.class;
        }
        return null;
    }

    private com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq.PartyType createIATAOrderReshopParty(S7NDCGdsAccount gdsAccount) {
        com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq.PartyType result = new com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq.PartyType();
        com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq.SenderType sender = new com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq.SenderType();
        TravelAgencyType travelAgency = new TravelAgencyType();
        travelAgency.setAgencyID(gdsAccount.getAgentUserSenderName());
        travelAgency.setPseudoCityID(gdsAccount.getPseudoCity());
        sender.setTravelAgency(travelAgency);
        result.setSender(sender);
        return result;
    }

    private PartyType createIATAOrderChangeParty(S7NDCGdsAccount gdsAccount) {
        PartyType result = new PartyType();
        SenderType sender = new SenderType();
        com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq.TravelAgencyType travelAgency = new com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq.TravelAgencyType();
        travelAgency.setAgencyID(gdsAccount.getAgentUserSenderName());
        travelAgency.setPseudoCityID(gdsAccount.getPseudoCity());
        sender.setTravelAgency(travelAgency);
        result.setSender(sender);
        return result;
    }

    private com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq.PartyType createIATAOrderListParty(S7NDCGdsAccount gdsAccount) {
        com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq.PartyType result = new com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq.PartyType();
        com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq.SenderType sender = new com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq.SenderType();
        com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq.TravelAgencyType travelAgency = new com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rq.TravelAgencyType();
        travelAgency.setAgencyID(gdsAccount.getAgentUserSenderName());
        travelAgency.setPseudoCityID(gdsAccount.getPseudoCity());
        sender.setTravelAgency(travelAgency);
        result.setSender(sender);
        return result;
    }

    private AgencyCoreRepType.OtherIDs.OtherID createOtherID(String description, String value) {
        AgencyCoreRepType.OtherIDs.OtherID otherID = new AgencyCoreRepType.OtherIDs.OtherID();
        otherID.setDescription(description);
        otherID.setString(value);
        return otherID;
    }
}

