/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.queue;

import com.gridnine.xtrip.common.gds.model.BaseQueueWatchEvent;
import com.gridnine.xtrip.common.model.gds.s7ndc.queue.S7NDCQueueReservationReference;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.BookingReferences;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FreeFormTextInstruction;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderChangeRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderCoreChangeType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderIDType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderInstructions;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderItemDetails;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderItemID;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderItemRepriceType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.RemarkType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class AddRemarkRequestBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        S7NDCQueueReservationReference ref = (S7NDCQueueReservationReference)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_RESERVATION_REFERENCE);
        BaseQueueWatchEvent event = (BaseQueueWatchEvent)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_EVENT);
        OrderChangeRQ request = new OrderChangeRQ();
        BookingReferences bookingReferences = new BookingReferences();
        bookingReferences.getBookingReferenceList().add(S7NDCHelper.buildGdsBookingReference(ref.getRecordLocator()));
        request.setQueryBookingReferences(bookingReferences);
        OrderCoreChangeType queryOrderOrderCoreChangeType = new OrderCoreChangeType();
        OrderIDType orderID = new OrderIDType();
        orderID.setOwner("S7");
        orderID.setString("UNKNOWN");
        queryOrderOrderCoreChangeType.setOrderID(orderID);
        request.setQueryOrderOrderCoreChangeType(queryOrderOrderCoreChangeType);
        OrderItemRepriceType queryOrderOrderItems = new OrderItemRepriceType();
        OrderItemRepriceType.OrderItem orderItem = new OrderItemRepriceType.OrderItem();
        OrderItemID orderItemID = new OrderItemID();
        orderItemID.setOwner("S7");
        orderItemID.setString("UNKNOWN");
        orderItem.setOrderItemID(orderItemID);
        OrderItemDetails details = new OrderItemDetails();
        OrderItemDetails.OrderItemDetail detail = new OrderItemDetails.OrderItemDetail();
        OrderInstructions instructions = new OrderInstructions();
        FreeFormTextInstruction ffti = new FreeFormTextInstruction();
        RemarkType.Remark remark = new RemarkType.Remark();
        String remarkText = String.format("G9Q / %s %s", event.getType().name().replaceAll("_", "."), LocalDateTime.now().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        remark.setString(remarkText);
        ffti.getRemarkList().add(remark);
        instructions.setFreeFormTextInstruction(ffti);
        detail.setOrderInstructions(instructions);
        details.getOrderItemDetailList().add(detail);
        orderItem.setOrderItemDetails(details);
        OrderItemRepriceType.OrderItem.ActionType actionType = new OrderItemRepriceType.OrderItem.ActionType();
        actionType.setString("Create");
        orderItem.setActionType(actionType);
        queryOrderOrderItems.getOrderItemList().add(orderItem);
        request.setQueryOrderOrderItems(queryOrderOrderItems);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_ACTION, (Object)"ChangeBook");
    }
}

