/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.queue;

import com.gridnine.xtrip.common.gds.model.BaseQueueReservationReference;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.gds.s7ndc.queue.S7NDCQueueWatchSettings;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ExcludeErrorProneReservationsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        List refs = (List)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_RESERVATION_REFERENCES);
        if (refs.isEmpty()) {
            return;
        }
        S7NDCQueueWatchSettings settings = (S7NDCQueueWatchSettings)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_SETTINGS);
        SearchQuery query = new SearchQuery();
        String queueTag = String.join((CharSequence)"|", GdsName.S7NDC.name(), settings.getPcc(), settings.getNumber());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.tag.name(), (Object)queueTag));
        List data = LogicalStorage.get().getAssetStorage().search(TemporalObject.class, query).getData();
        if (data.isEmpty()) {
            return;
        }
        TemporalObject to = (TemporalObject)data.get(0);
        Set errorProneRecordLocators = Arrays.stream(new String(((TemporalObject)data.get(0)).getData(), StandardCharsets.UTF_8).split("\\|")).collect(Collectors.toSet());
        Set recordLocators = refs.stream().map(BaseQueueReservationReference::getRecordLocator).collect(Collectors.toSet());
        errorProneRecordLocators.removeIf(recordLocator -> !recordLocators.contains(recordLocator));
        if (errorProneRecordLocators.isEmpty()) {
            LogicalStorage.get().getAssetStorage().delete((BaseAsset)to);
        } else {
            refs.removeIf(ref -> errorProneRecordLocators.contains(ref.getRecordLocator()));
            to.setData(TextUtil.join((String)"|", errorProneRecordLocators).getBytes(StandardCharsets.UTF_8));
            LogicalStorage.get().getAssetStorage().save((BaseAsset)to);
        }
    }
}

