/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.queue;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.gds.s7ndc.queue.QueueCategory;
import com.gridnine.xtrip.common.model.gds.s7ndc.queue.S7NDCQueueWatchSettings;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class QueueCategoriesProvider
extends BaseTargetsProvider<QueueCategory> {
    private static final Pattern CATEGORY_PATTERN = Pattern.compile("C(?<categoryNumber>\\d{1,2})(D(?<subcategoryNumber>\\d))?");

    public Collection<QueueCategory> getTargets(MessageContext ctx) throws Exception {
        S7NDCQueueWatchSettings settings = (S7NDCQueueWatchSettings)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_SETTINGS);
        List categoriesCollection = TextUtil.string2List((String)settings.getCategories(), (String)"[,;]");
        List<String> categories = categoriesCollection.stream().distinct().filter(c -> CATEGORY_PATTERN.matcher((CharSequence)c).matches()).collect(Collectors.toList());
        if (categories.isEmpty()) {
            throw Xeption.forDeveloper((String)"Queue categories are wrong or absent", (Object[])new Object[0]);
        }
        if (categoriesCollection.size() != categories.size()) {
            this.log.warn("Some queue categories are wrong or don't match pattern");
        }
        ArrayList<QueueCategory> result = new ArrayList<QueueCategory>();
        categories.forEach(category -> {
            QueueCategory queueCategory = new QueueCategory();
            Matcher matcher = CATEGORY_PATTERN.matcher((CharSequence)category);
            if (matcher.find()) {
                queueCategory.setCategoryNumber(matcher.group("categoryNumber"));
                queueCategory.setSubCategoryNumber(matcher.group("subcategoryNumber"));
                result.add(queueCategory);
            }
        });
        return result;
    }
}

