/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.queue;

import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.gds.s7ndc.queue.QueueCategory;
import com.gridnine.xtrip.common.model.gds.s7ndc.queue.S7NDCQueueReservationReference;
import com.gridnine.xtrip.common.model.gds.s7ndc.queue.S7NDCQueueWatchSettings;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs.IATAOrderListRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderList.rs.QueueListReply;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;

public class QueueListReplyParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        QueueListReply reply;
        IATAOrderListRS response = (IATAOrderListRS)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
        S7NDCQueueWatchSettings settings = (S7NDCQueueWatchSettings)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_SETTINGS);
        QueueCategory category = (QueueCategory)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_CATEGORY);
        ArrayList<S7NDCQueueReservationReference> refs = (ArrayList<S7NDCQueueReservationReference>)ctx.getObject((Enum)IBusGdsQueueContextKeys.QUEUE_RESERVATION_REFERENCES);
        if (refs == null) {
            refs = new ArrayList<S7NDCQueueReservationReference>();
            ctx.putObject((Enum)IBusGdsQueueContextKeys.QUEUE_RESERVATION_REFERENCES, refs);
        }
        if ((reply = response.getAugmentationPoint()).getQueueView() != null && reply.getQueueView().getItemList() != null) {
            for (QueueListReply.QueueView.Item item : reply.getQueueView().getItemList()) {
                String recLoc = item.getRecLoc().getReservation().getControlNumber();
                S7NDCQueueReservationReference ref = new S7NDCQueueReservationReference(recLoc);
                ref.setRecordLocator(recLoc);
                ref.setRecordLocatorType(RecordLocatorType.DEFAULT);
                ref.setGdsName(GdsName.S7NDC);
                ref.setGdsAccount(settings.getGdsAccount());
                ref.setCategoryNumber(category.getCategoryNumber());
                ref.setSubCategoryNumber(category.getSubCategoryNumber());
                refs.add(ref);
            }
        }
    }
}

