/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.queue;

import com.gridnine.xtrip.common.gds.model.BaseQueueWatchEvent;
import com.gridnine.xtrip.common.gds.model.GdsSegment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderItemCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderViewRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TicketDocument;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class S7NDCBaseQueueWatchEventParser
extends BaseProcessor {
    private static final Set<String> UNCOFIRMED_SEGMENT_STATUS = new HashSet<String>(Arrays.asList("UN", "UC"));
    private static final Set<String> CHANGED_SEGMENT_STATUS = new HashSet<String>(Arrays.asList("TK"));
    private static final Set<String> CANCELLED_SEGMENT_STATUS = new HashSet<String>(Arrays.asList("HX", "UC", "UN", "XX", "OX"));

    public void process(MessageContext ctx) throws Exception {
        BaseQueueWatchEvent event = (BaseQueueWatchEvent)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_EVENT);
        OrderViewRS response = (OrderViewRS)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
        OrderItemCoreType.OrderItem orderItem = (OrderItemCoreType.OrderItem)((OrderViewRS.Order)response.getOrderList().get(0)).getOrderItems().getOrderItemList().get(0);
        List segments = orderItem.getFlightItem().getOriginDestinationList().stream().flatMap(od -> od.getFlightList().stream()).collect(Collectors.toList());
        for (FlightType.Flight segment : segments) {
            GdsSegment seg = new GdsSegment();
            seg.setRecordNumber(Integer.parseInt(segment.getSegmentKey().getSegmentKey().substring(2)));
            seg.setAirline(S7NDCHelper.resolveIataNativeCode(Airline.class, segment.getMarketingCarrier().getAirlineID().getString()));
            seg.setFlightNumber(segment.getMarketingCarrier().getFlightNumber().getString());
            seg.setBookingClass(segment.getClassOfService().getCodeString());
            seg.setDepartureDateTime(S7NDCHelper.buildDateTime(segment.getDeparture().getDate(), segment.getDeparture().getTime1()));
            seg.setArrivalDateTime(S7NDCHelper.buildDateTime(segment.getArrival().getDate(), segment.getArrival().getTime1()));
            seg.setDepartureLocation(S7NDCHelper.resolveIataNativeCode(GeoLocation.class, segment.getDeparture().getAirportCodeString()));
            seg.setArrivalLocation(S7NDCHelper.resolveIataNativeCode(GeoLocation.class, segment.getArrival().getAirportCodeString()));
            seg.setSegmentStatus(segment.getStatus().getStatusCode().getCode());
            seg.setSeatCount(this.getSeatCount(orderItem));
            seg.setUnconfirmed(UNCOFIRMED_SEGMENT_STATUS.contains(seg.getSegmentStatus()));
            seg.setChanged(CHANGED_SEGMENT_STATUS.contains(seg.getSegmentStatus()));
            seg.setCancelled(CANCELLED_SEGMENT_STATUS.contains(seg.getSegmentStatus()));
            event.getGdsSegments().add(seg);
            event.setHasTickets(this.isHasTickets(response));
        }
    }

    private int getSeatCount(OrderItemCoreType.OrderItem orderItem) {
        String passengerReferences = orderItem.getAssociations().getPassengers().getPassengerReferences().getPassengerReferences();
        return (int)Arrays.stream(passengerReferences.split(" ")).map(ref -> ref.replaceAll("\\D", "")).distinct().count();
    }

    private boolean isHasTickets(OrderViewRS response) {
        if (response.getTicketDocInfos() == null || response.getTicketDocInfos().getTicketDocInfoList().isEmpty()) {
            return false;
        }
        return ((TicketDocument)((OrderViewRS.TicketDocInfos.TicketDocInfo)response.getTicketDocInfos().getTicketDocInfoList().get(0)).getTicketDocumentList().get(0)).getTicketDocNbr() != null;
    }
}

