/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.queue;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.gds.s7ndc.queue.S7NDCQueueReservationReference;
import com.gridnine.xtrip.common.model.gds.s7ndc.queue.S7NDCQueueWatchSettings;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class SaveErrorProneRecordLocatorProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) {
        TemporalObject to;
        S7NDCQueueReservationReference ref = (S7NDCQueueReservationReference)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_RESERVATION_REFERENCE);
        S7NDCQueueWatchSettings settings = (S7NDCQueueWatchSettings)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_SETTINGS);
        SearchQuery query = new SearchQuery();
        String queueTag = String.join((CharSequence)"|", GdsName.S7NDC.name(), settings.getPcc(), settings.getNumber());
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.tag.name(), (Object)queueTag));
        List data = LogicalStorage.get().getAssetStorage().search(TemporalObject.class, query).getData();
        TemporalObject temporalObject = to = data.isEmpty() ? new TemporalObject() : (TemporalObject)data.get(0);
        if (!data.isEmpty()) {
            to.setData(ArrayUtils.addAll((byte[])to.getData(), (byte[])("|" + ref.getRecordLocator()).getBytes(StandardCharsets.UTF_8)));
        } else {
            to.setTag(queueTag);
            to.setData(ref.getRecordLocator().getBytes(StandardCharsets.UTF_8));
        }
        to.setExpired(new Date(new Date().getTime() + 604800000L));
        LogicalStorage.get().getAssetStorage().save((BaseAsset)to);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_QUEUE_ERROR_PRONE_RESERVATION_REF, (Object)ref);
    }
}

