/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.queue;

import com.gridnine.xtrip.common.gds.model.ServiceStatusChangeEvent;
import com.gridnine.xtrip.server.gds.ibus.queue.IBusGdsQueueContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirDocDisplayRS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class ServicesStatusParser
extends BaseProcessor {
    private static final Set<String> IGNORED_STATUSES = new HashSet<String>();

    public void process(MessageContext ctx) throws Exception {
        ServiceStatusChangeEvent event = (ServiceStatusChangeEvent)ctx.getMandatoryObject((Enum)IBusGdsQueueContextKeys.QUEUE_WATCH_EVENT);
        AirDocDisplayRS response = (AirDocDisplayRS)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
        Set statuses = response.getTicketDocInfos().getTicketDocInfoList().stream().flatMap(docInfo -> docInfo.getTicketDocumentList().stream()).filter(doc -> "Y".equals(doc.getType().getCode())).flatMap(tktDoc -> tktDoc.getCouponInfoList().stream()).map(coupon -> coupon.getStatus().getCode()).collect(Collectors.toSet());
        if (statuses.size() == 1) {
            event.setStatus((String)statuses.iterator().next());
        }
        if (statuses.size() > 1) {
            for (String status : statuses) {
                if (IGNORED_STATUSES.contains(status)) continue;
                event.setStatus(status);
                break;
            }
            if (event.getStatus() == null) {
                event.setStatus((String)statuses.iterator().next());
            }
        }
    }

    static {
        IGNORED_STATUSES.add("ISSUED");
        IGNORED_STATUSES.add("VOIDED");
    }
}

