/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.refundReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.midoffice.model.GdsProductRefexFinanceDetails;
import com.gridnine.xtrip.common.midoffice.model.UnsellFinanceDetails;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.AirProductTaxHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs.AmountType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs.DeleteOrderItemType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs.IATAOrderReshopRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs.OfferType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs.ReshopDifferentialType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Objects;

public class IataOrderReshopRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        UnsellFinanceDetails unsellFinanceDetails = (UnsellFinanceDetails)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.UNSELL_FINANCE_DETAILS);
        IATAOrderReshopRS response = (IATAOrderReshopRS)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        for (OfferType gdsOffer : response.getResponse().getReshopResults().getReshopOffers().getOfferList()) {
            String systemNumber = S7NDCHelper.extractProductSystemNumber(gdsOffer.getOfferID());
            Product product = GDSHelper.findProductBySystemNumber((Reservation)reservation, (String)systemNumber);
            if (product == null) {
                throw Xeption.forDeveloper((String)"can't find product with number {0}", (Object[])new Object[]{systemNumber});
            }
            GdsProductRefexFinanceDetails gdsProductRefexFinanceDetails = (GdsProductRefexFinanceDetails)unsellFinanceDetails.getGdsDetails().get((Object)product.getUid());
            if (gdsProductRefexFinanceDetails == null) {
                throw Xeption.forDeveloper((String)"can't find refex details for product with number {0}", (Object[])new Object[]{systemNumber});
            }
            BigDecimal differentialAmountDue = gdsOffer.getDeleteOrderItemList().stream().filter(Objects::nonNull).map(DeleteOrderItemType::getDifferentialAmountDue).filter(Objects::nonNull).map(ReshopDifferentialType::getAmount).filter(Objects::nonNull).map(AmountType::getDecimal).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (MiscUtil.isZero((BigDecimal)differentialAmountDue, (boolean)true)) {
                gdsProductRefexFinanceDetails.setEquivalentFare(BigDecimal.ZERO);
                gdsProductRefexFinanceDetails.setBaseFare(MoneyHelper.buildMoney((BigDecimal)BigDecimal.ZERO, (String)product.getGdsCurrency()));
                continue;
            }
            BigDecimal eqFare = AirProductHelper.getEquivalentFare((Product)product);
            gdsProductRefexFinanceDetails.setEquivalentFare(eqFare);
            gdsProductRefexFinanceDetails.setBaseFare(MoneyHelper.buildMoney((BigDecimal)eqFare, (String)product.getGdsCurrency()));
            gdsProductRefexFinanceDetails.getTaxes().addAll(AirProductTaxHelper.getSimpleTaxes((Product)product));
            BigDecimal penalty = gdsOffer.getDeleteOrderItemList().stream().filter(Objects::nonNull).map(DeleteOrderItemType::getPenaltyDifferential).filter(Objects::nonNull).map(ReshopDifferentialType::getAmount).filter(Objects::nonNull).map(AmountType::getDecimal).reduce(BigDecimal.ZERO, BigDecimal::add);
            gdsProductRefexFinanceDetails.setPenalty(penalty);
            BigDecimal sellTotal = AirProductHelper.calculateTotalEquivalentFare((Product)product);
            BigDecimal refundTotal = MiscUtil.sub((BigDecimal)sellTotal, (BigDecimal[])new BigDecimal[]{penalty});
            if (MiscUtil.equals((Object)differentialAmountDue, (Object)refundTotal)) continue;
            throw Xeption.forDeveloper((String)"\u0421\u0443\u043c\u043c\u0430 \u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0443 {0} \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044e \u0432 \u041c\u041e\u041c {1} ({2}-{3})", (Object[])new Object[]{differentialAmountDue, refundTotal, sellTotal, penalty});
        }
    }
}

