/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.repriceReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Tax;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.server.gds.helper.GDSHelper;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareComponentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ItinReshopRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OfferPriceLeadType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PricedFlightOfferAssocType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.RemarkType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TaxDetailType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerInfoAssocType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerReferences;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InitReshopRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        HashMap products = new HashMap();
        for (Product product : GDSHelper.getProducts((Reservation)reservation)) {
            if (!products.containsKey(product.getPassengerType())) {
                products.put(product.getPassengerType(), new ArrayList());
            }
            ((List)products.get(product.getPassengerType())).add(product);
        }
        ItinReshopRS response = (ItinReshopRS)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
        HashMap<String, DictionaryReference<PassengerType>> passengerTypes = new HashMap<String, DictionaryReference<PassengerType>>();
        for (ItinReshopRS.Passenger passenger : response.getPassengerList()) {
            passengerTypes.put(passenger.getObjectKeyAttrGroup().getObjectKey(), S7NDCHelper.resolveS7NDCNativeCode(PassengerType.class, passenger.getPTC1().getString()));
        }
        for (OfferPriceLeadType offerPrice : ((ItinReshopRS.ReShopOffer)response.getResponseReShopOfferList().get(0)).getReShopPricedOffer().getOfferPriceList()) {
            String ptCode = offerPrice.getRequestedDateAssociationList().stream().filter(a -> a.getAssociatedTraveler() != null).map(PricedFlightOfferAssocType::getAssociatedTraveler).map(TravelerInfoAssocType::getTravelerReferences).map(TravelerReferences::getTravelerReferences).findAny().get();
            DictionaryReference passengerType = (DictionaryReference)passengerTypes.get(ptCode);
            for (Product product : (List)products.get(passengerType)) {
                product.getFares().clear();
                product.getTaxes().clear();
                BigDecimal fare = offerPrice.getRequestedDateOfferPriceLeadDetailType().getPriceDetailBaseAmount().getDecimal();
                ProductFare pf = new ProductFare();
                pf.setEquivalentFare(fare);
                pf.setBaseFare(MoneyHelper.buildMoney((BigDecimal)fare, (String)product.getGdsCurrency()));
                product.getFares().add(pf);
                if (offerPrice.getRequestedDateOfferPriceLeadDetailType().getPriceDetailTaxes() != null && offerPrice.getRequestedDateOfferPriceLeadDetailType().getPriceDetailTaxes().getBreakdown() != null && offerPrice.getRequestedDateOfferPriceLeadDetailType().getPriceDetailTaxes().getBreakdown().getTaxList() != null) {
                    for (TaxDetailType.Breakdown.Tax tax : offerPrice.getRequestedDateOfferPriceLeadDetailType().getPriceDetailTaxes().getBreakdown().getTaxList()) {
                        Tax t = new Tax();
                        t.setEquivalentAmount(tax.getAmount().getDecimal());
                        t.setCode(tax.getTaxCode());
                        product.getTaxes().add(t);
                    }
                }
                product.setFareCalculationData(((RemarkType.Remark)((FareComponentType)offerPrice.getFareDetail().getFareComponentList().get(0)).getFareRules().getRemarks().getRemarkList().get(0)).getString());
            }
        }
    }
}

