/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.repriceReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.SegmentWrapper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.BookingReferences;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightItem;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ItinReshopRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ObjectKeyAttrGroup;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderFareDetailType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderItemCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Passenger;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PassengerReferences;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ItinReshopRQBuilder
extends BaseProcessor {
    private boolean includeBookingReferences;

    public void configure(Map<String, String> parameters) {
        this.includeBookingReferences = Boolean.parseBoolean(parameters.get("includeBookingReferences"));
    }

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ItinReshopRQ itinReshopRq = new ItinReshopRQ();
        ArrayList<ItinReshopRQ.Actions> listActions = new ArrayList<ItinReshopRQ.Actions>();
        ItinReshopRQ.Actions actions = new ItinReshopRQ.Actions();
        actions.setActionTypeString("");
        if (this.includeBookingReferences) {
            BookingReferences bookingReferences = new BookingReferences();
            bookingReferences.getBookingReferenceList().add(S7NDCHelper.buildGdsBookingReference(reservation));
            actions.setBookingReferences(bookingReferences);
        }
        OrderItemCoreType orderItems = new OrderItemCoreType();
        List products = AirProductHelper.getAirProductsList((Reservation)reservation);
        OrderItemCoreType.OrderItem orderItem = new OrderItemCoreType.OrderItem();
        FlightItem flightItem = new FlightItem();
        Product prod = (Product)AirProductHelper.getAirProductsList((Reservation)reservation).get(0);
        OrderFareDetailType orderFareDetailTypeDetail = new OrderFareDetailType();
        List segments = prod.getSegmentTariffs().stream().flatMap(segmentTariff -> segmentTariff.getSegments().stream()).collect(Collectors.toList());
        List<FlightType> originDestinationList = S7NDCHelper.initializeOriginDestinations(segments, seg -> new SegmentWrapper((Segment)seg), comp -> orderFareDetailTypeDetail.getFareComponentList().add(comp));
        flightItem.setOriginDestinationList(originDestinationList);
        flightItem.setFareDetail(orderFareDetailTypeDetail);
        orderItem.setFlightItem(flightItem);
        OrderItemCoreType.OrderItem.Associations associations = new OrderItemCoreType.OrderItem.Associations();
        OrderItemCoreType.OrderItem.Associations.Passengers passengers = new OrderItemCoreType.OrderItem.Associations.Passengers();
        PassengerReferences passengerReferences = new PassengerReferences();
        passengerReferences.setPassengerReferences(products.stream().map(Product::getGdsId).collect(Collectors.joining(" ")));
        passengers.setPassengerReferences(passengerReferences);
        associations.setPassengers(passengers);
        orderItem.setAssociations(associations);
        orderItems.getOrderItemList().add(orderItem);
        actions.setOrderItems(orderItems);
        ItinReshopRQ.Actions.Passengers passengers2 = new ItinReshopRQ.Actions.Passengers();
        for (Product product : products) {
            Passenger passenger = new Passenger();
            ObjectKeyAttrGroup objectKeyAttrGroup = new ObjectKeyAttrGroup();
            objectKeyAttrGroup.setObjectKey(product.getGdsId());
            passenger.setObjectKeyAttrGroup(objectKeyAttrGroup);
            TravelerCoreType.PTC ptc1 = new TravelerCoreType.PTC();
            ptc1.setQuantity(BigInteger.ONE);
            ptc1.setString(S7NDCHelper.getS7NDCNativeCode(product.getPassengerType()));
            passenger.setPTC1(ptc1);
            passenger.setNameSurnameString("Anonymous");
            passengers2.getPassengerList().add(passenger);
        }
        actions.setPassengers(passengers2);
        if (!StringUtils.isBlank((String)reservation.getAccountCode())) {
            ItinReshopRQ.Actions.Qualifiers qualifiers = new ItinReshopRQ.Actions.Qualifiers();
            ItinReshopRQ.Actions.Qualifiers.Qualifier qualifier = new ItinReshopRQ.Actions.Qualifiers.Qualifier();
            qualifier.setSpecialFareQualifiers(S7NDCHelper.buildAccountCodeFareQualifier(reservation.getAccountCode()));
            qualifiers.getQualifierList().add(qualifier);
            actions.setQualifiers(qualifiers);
        }
        listActions.add(actions);
        itinReshopRq.setQueryReshopList(listActions);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_REQUEST_PAYLOAD, (Object)itinReshopRq);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_ACTION, (Object)"Reprice");
    }
}

