/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.repriceReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.DataListObjAttrGroup;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.DataListType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareCode;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareList;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.SegmentKey;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServicePriceRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.SrvPriceReqParamsType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Travelers;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class ServicePriceRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Product anyAdultProduct = AirProductHelper.getProducts((Reservation)reservation).stream().filter(p -> p.getProductCategory() == ProductCategory.AIR).filter(p -> DictHelper.isAdultPassengerTypeCategory((DictionaryReference)p.getPassengerType())).findAny().get();
        ServicePriceRQ request = new ServicePriceRQ();
        request.setQuery(new ServicePriceRQ.Query());
        DataListType dataList = new DataListType();
        dataList.setFareList(new FareList());
        request.setDataList(dataList);
        FlightType od = null;
        int segIdx = 1;
        for (Segment s : AirProductHelper.getSegments((Collection)anyAdultProduct.getSegmentTariffs())) {
            if (s.isStarting()) {
                od = new FlightType();
                request.getQuery().getOriginDestinationList().add(od);
            }
            FlightType.Flight gdsFlight = new FlightType.Flight();
            SegmentKey segmentKey = new SegmentKey();
            segmentKey.setSegmentKey("SEG".concat(Integer.toString(segIdx)));
            gdsFlight.setSegmentKey(segmentKey);
            gdsFlight.setDeparture(S7NDCHelper.buildFlightDepartureType((DictionaryReference<GeoLocation>)s.getDepartureLocation(), s.getStartDate()));
            gdsFlight.setArrival(S7NDCHelper.buildFlightArrivalType((DictionaryReference<GeoLocation>)s.getArriveLocation(), s.getEndDate()));
            gdsFlight.setMarketingCarrier(S7NDCHelper.buildMarketingCarrierFlightType((DictionaryReference<Airline>)s.getAirline(), s.getFlightNo()));
            od.getFlightList().add(gdsFlight);
            FareList.FareGroup fareGroup = new FareList.FareGroup();
            DataListObjAttrGroup attrs = new DataListObjAttrGroup();
            attrs.setRefs("SEG".concat(Integer.toString(segIdx)));
            attrs.setListKey("FG".concat(Integer.toString(segIdx)));
            fareGroup.setDataListObjAttrGroup(attrs);
            FareCode fareFareCode = new FareCode();
            fareFareCode.setCode("ANY");
            fareGroup.setFareFareCode(fareFareCode);
            fareGroup.setFareBasisCodeCode(s.getFareBasis());
            request.getDataList().getFareList().getFareGroupList().add(fareGroup);
            ++segIdx;
        }
        Set pts = AirProductHelper.getProducts((Reservation)reservation).stream().filter(p -> p.getProductCategory() == ProductCategory.MCO).map(Product::getPassengerType).collect(Collectors.toSet());
        Travelers travelers = new Travelers();
        for (DictionaryReference pt : pts) {
            Travelers.Traveler traveler = new Travelers.Traveler();
            TravelerCoreType anonymousTraveler = new TravelerCoreType();
            TravelerCoreType.PTC ptc = new TravelerCoreType.PTC();
            ptc.setString(S7NDCHelper.getS7NDCNativeCode(pt));
            anonymousTraveler.setPTC1(ptc);
            traveler.setAnonymousTraveler(anonymousTraveler);
            travelers.getTravelerList().add(traveler);
        }
        request.setTravelers(travelers);
        SrvPriceReqParamsType reqParams = new SrvPriceReqParamsType();
        reqParams.setServiceFilters(S7NDCHelper.buildBaggageServiceFilters());
        request.setParameters(reqParams);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_REQUEST_PAYLOAD, (Object)request);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_ACTION, (Object)"ServicePrice");
    }
}

