/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.repriceReservation;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.ProductFare;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.v052.ServicePriceRSHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ListOfFlightSegmentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OriginDestination;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServiceCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServiceDetailType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServicePriceRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServicePriceType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ServicePriceRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ServicePriceRS response = (ServicePriceRS)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
        Map<String, OriginDestination> odDataList = ServicePriceRSHelper.getOdDataList(response);
        Map<String, ListOfFlightSegmentType> segDataList = ServicePriceRSHelper.getSegDataList(response);
        Map<String, TravelerCoreType> shDataList = ServicePriceRSHelper.getShDataList(response);
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List mcoProducts = AirProductHelper.getProducts((Reservation)reservation).stream().filter(p -> p.getProductCategory() == ProductCategory.MCO).collect(Collectors.toList());
        for (Product mcoProduct : mcoProducts) {
            Product mainProduct = (Product)mcoProduct.getRelatedProducts().get(0);
            List mainSegments = AirProductHelper.getSegments((Collection)mainProduct.getSegmentTariffs());
            Set mcoSegmentNumbers = AirProductHelper.getSegments((Collection)mcoProduct.getSegmentTariffs()).stream().map(seg -> ServicePriceRSParser.getSegmentIndex((List<Segment>)mainSegments, seg)).collect(Collectors.toSet());
            ServiceDetailType service = response.getServices().getServiceList().stream().filter(s -> !BigDecimal.ZERO.equals(((ServicePriceType)s.getPriceList().get(0)).getTotal().getDecimal())).filter(s -> mcoProduct.getGdsId().equals(s.getBookingInstructions().getOSITextList().get(0))).filter(s -> ServicePriceRSParser.passengerTypeMatches(ServicePriceRSHelper.getPassengerTypeCodes((ServiceCoreType)s, shDataList), (DictionaryReference<PassengerType>)mcoProduct.getPassengerType())).filter(s -> ServicePriceRSHelper.getSegmentNumbers((ServiceCoreType)s, mainSegments, ServicePriceRSParser::getSegmentIndex, odDataList, segDataList).equals(mcoSegmentNumbers)).findAny().orElseThrow(() -> Xeption.forDeveloper((String)"service not found for mco product ".concat(mcoProduct.getUid()), (Object[])new Object[0]));
            BigDecimal fare = ((ServicePriceType)service.getPriceList().get(0)).getTotal().getDecimal();
            mcoProduct.getFares().clear();
            ProductFare pf = new ProductFare();
            pf.setEquivalentFare(fare);
            pf.setBaseFare(MoneyHelper.buildMoney((BigDecimal)fare, (String)mcoProduct.getGdsCurrency()));
            mcoProduct.getFares().add(pf);
        }
    }

    private static boolean passengerTypeMatches(Set<String> pts, DictionaryReference<PassengerType> pt) {
        if (pts.isEmpty()) {
            return true;
        }
        return pts.contains(S7NDCHelper.getS7NDCNativeCode(pt));
    }

    private static int getSegmentIndex(List<Segment> segments, ListOfFlightSegmentType gdsFs) {
        for (int i = 0; i < segments.size(); ++i) {
            Segment s = segments.get(i);
            if (!Objects.equals(gdsFs.getMarketingCarrier().getAirlineID().getString(), S7NDCHelper.getIataNativeCode(s.getAirline())) || !Objects.equals(gdsFs.getMarketingCarrier().getFlightNumber().getString(), s.getFlightNo()) || !Objects.equals(MiscUtil.clearTime((Date)gdsFs.getDeparture().getDate()), MiscUtil.clearTime((Date)s.getStartDate()))) continue;
            return i;
        }
        throw Xeption.forDeveloper((String)String.format("segment not found %s %s %s", gdsFs.getMarketingCarrier().getAirlineID().getString(), gdsFs.getMarketingCarrier().getFlightNumber().getString(), gdsFs.getDeparture().getDate()), (Object[])new Object[0]);
    }

    private static int getSegmentIndex(List<Segment> segments, Segment seg) {
        for (int i = 0; i < segments.size(); ++i) {
            Segment s = segments.get(i);
            if (!Objects.equals(seg.getAirline(), s.getAirline()) || !Objects.equals(seg.getFlightNo(), s.getFlightNo()) || !Objects.equals(MiscUtil.clearTime((Date)seg.getStartDate()), MiscUtil.clearTime((Date)s.getStartDate()))) continue;
            return i;
        }
        throw Xeption.forDeveloper((String)String.format("segment not found %s %s %s", seg.getAirline(), seg.getFlightNo(), seg.getStartDate()), (Object[])new Object[0]);
    }
}

