/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.searchFlightFares;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.CurrCode;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightArrivalType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightCOSCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightDepartureType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightPriceRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FltPriceReqParamsType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.MessageParamsBaseType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Qualifiers;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Travelers;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FlightPriceRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_REQUEST_PAYLOAD, (Object)this.createFlightInfoRQ(flight));
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_ACTION, (Object)"FlightInfo");
    }

    private FlightPriceRQ createFlightInfoRQ(Flight flight) {
        FlightPriceRQ request = new FlightPriceRQ();
        Travelers travelers = new Travelers();
        for (SeatPreferences sp : flight.getSeats()) {
            Travelers.Traveler traveler = new Travelers.Traveler();
            TravelerCoreType anonymousTraveler = new TravelerCoreType();
            TravelerCoreType.PTC ptc = new TravelerCoreType.PTC();
            ptc.setQuantity(BigInteger.valueOf(sp.getCount()));
            ptc.setString(S7NDCHelper.getS7NDCNativeCode(sp.getPassengerType()));
            anonymousTraveler.setPTC1(ptc);
            traveler.setAnonymousTraveler(anonymousTraveler);
            travelers.getTravelerList().add(traveler);
        }
        request.setTravelers(travelers);
        FltPriceReqParamsType parameters = new FltPriceReqParamsType();
        MessageParamsBaseType.CurrCodes currCodes = new MessageParamsBaseType.CurrCodes();
        CurrCode currCode = new CurrCode();
        currCode.setString(flight.getGdsCurrencyCode());
        currCodes.getCurrCodeList().add(currCode);
        parameters.setCurrCodes(currCodes);
        request.setParameters(parameters);
        request.setQueryList(new ArrayList());
        request.getQueryList().addAll(this.buildQueries(flight));
        if (!StringUtils.isBlank((String)flight.getAccountCode())) {
            Qualifiers qualifiers = new Qualifiers();
            Qualifiers.Qualifier qualifier = new Qualifiers.Qualifier();
            qualifier.setSpecialFareQualifiers(S7NDCHelper.buildAccountCodeFareQualifier(flight.getAccountCode()));
            qualifiers.getQualifierList().add(qualifier);
            request.setQualifiers(qualifiers);
        }
        return request;
    }

    private List<FlightType> buildQueries(Flight flight) {
        ArrayList<FlightType> result = new ArrayList<FlightType>();
        FlightType query = null;
        for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
            if (fs.isStarting()) {
                if (query != null) {
                    result.add(query);
                }
                query = new FlightType();
            }
            FlightType.Flight fl = new FlightType.Flight();
            FlightDepartureType departure = new FlightDepartureType();
            departure.setAirportCodeString(S7NDCHelper.getIataNativeCode(fs.getLocationBegin()));
            departure.setDate(new Date(fs.getDateBegin().getTime()));
            fl.setDeparture(departure);
            FlightArrivalType arrival = new FlightArrivalType();
            arrival.setAirportCodeString(S7NDCHelper.getIataNativeCode(fs.getLocationEnd()));
            fl.setArrival(arrival);
            fl.setMarketingCarrier(S7NDCHelper.buildMarketingCarrierFlightType((DictionaryReference<Airline>)fs.getAirline(), fs.getFlightNumber()));
            FlightCOSCoreType classOfService = new FlightCOSCoreType();
            classOfService.setCodeString(fs.getBookingClass());
            fl.setClassOfService(classOfService);
            query.getFlightList().add(fl);
        }
        result.add(query);
        return result;
    }
}

