/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.searchFlightFares;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.gds.s7ndc.S7NDCGdsAccount;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.v052.DataListsIndex;
import com.gridnine.xtrip.server.gds.s7ndc.v052.FlightConverterHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightPriceRS;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Iterator;

public class FlightPriceRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightPriceRS response = (FlightPriceRS)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ArrayList<Flight> flights = new ArrayList<Flight>();
        DataListsIndex index = new DataListsIndex(response.getDataLists());
        Flight oldFlight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        for (FlightPriceRS.AirlineOffers.AirlineOffer airlineOffer : response.getAirlineOffers().getAirlineOfferList()) {
            Flight flight = FlightConverterHelper.buildFlight(oldFlight.getAccountCode(), (EntityContainer<S7NDCGdsAccount>)gdsAccountCtr, response.getDataLists().getAnonymousTravelerList().getAnonymousTravelerList(), airlineOffer.getPricedOffer().getOfferPriceList(), index, salesContext);
            flight.setAncillaryFeesRequestNeeded(FlightHelper.getSegments((Flight)flight).stream().map(FlightSegment::getOperatingAirline).allMatch(a -> S7NDCHelper.getS7AirlineReference().equals(a)));
            FlightConverterHelper.copyTechStopInfo(oldFlight, flight);
            if (!this.isAppropriateClassOfService(flight, oldFlight)) continue;
            flights.add(flight);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, flights);
    }

    private boolean isAppropriateClassOfService(Flight flight, Flight oldFlight) {
        Iterator segIter = FlightHelper.getSegments((Flight)flight).iterator();
        for (FlightSegment flightSegment : FlightHelper.getSegments((Flight)oldFlight)) {
            if (flightSegment.getServiceClass() == ((FlightSegment)segIter.next()).getServiceClass()) continue;
            return false;
        }
        return true;
    }
}

