/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.gds.s7ndc.S7NDCGdsAccount;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirShopReqAttributeQueryType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirShopReqParamsType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirShoppingRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirlineIDType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.CurrCode;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareQualifierType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightArrivalType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightDepartureType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightPreferencesType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.MessageParamsBaseType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ServiceFilterType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Travelers;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Collection;

public class AirShoppingRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        AirShoppingRQ airShoppingRQ = new AirShoppingRQ();
        Travelers travelers = new Travelers();
        for (SeatPreferences seatPreferences : fsp.getSeats()) {
            Travelers.Traveler traveler = new Travelers.Traveler();
            TravelerCoreType anonymousTraveler = new TravelerCoreType();
            TravelerCoreType.PTC ptc = new TravelerCoreType.PTC();
            ptc.setQuantity(new BigInteger(String.valueOf(seatPreferences.getCount())));
            ptc.setString(S7NDCHelper.getS7NDCNativeCode(seatPreferences.getPassengerType()));
            anonymousTraveler.setPTC1(ptc);
            traveler.setAnonymousTraveler(anonymousTraveler);
            travelers.getTravelerList().add(traveler);
        }
        airShoppingRQ.setTravelers(travelers);
        AirShopReqAttributeQueryType coreQueryOriginDestinations = new AirShopReqAttributeQueryType();
        for (RouteSegment routeSegment : fsp.getRoute()) {
            AirShopReqAttributeQueryType.OriginDestination originDestination = new AirShopReqAttributeQueryType.OriginDestination();
            FlightDepartureType departure = new FlightDepartureType();
            departure.setAirportCodeString(S7NDCHelper.getIataNativeCode(routeSegment.getLocationBegin()));
            departure.setDate(new Date(routeSegment.getDate().getTime()));
            originDestination.setDeparture(departure);
            FlightArrivalType arrival = new FlightArrivalType();
            arrival.setAirportCodeString(S7NDCHelper.getIataNativeCode(routeSegment.getLocationEnd()));
            originDestination.setArrival(arrival);
            coreQueryOriginDestinations.getOriginDestinationList().add(originDestination);
        }
        airShoppingRQ.setCoreQueryOriginDestinations(coreQueryOriginDestinations);
        AirShoppingRQ.Preferences preferences = new AirShoppingRQ.Preferences();
        AirShoppingRQ.Preferences.Preference preference = new AirShoppingRQ.Preferences.Preference();
        FlightPreferencesType flightPreferences = new FlightPreferencesType();
        FlightPreferencesType.Aircraft aircraft = new FlightPreferencesType.Aircraft();
        FlightPreferencesType.Aircraft.Cabins cabins = new FlightPreferencesType.Aircraft.Cabins();
        FlightPreferencesType.Aircraft.Cabins.Cabin cabin = new FlightPreferencesType.Aircraft.Cabins.Cabin();
        cabin.setCode(S7NDCHelper.buildClassOfService(fsp.getServiceClass()));
        cabins.getCabinList().add(cabin);
        aircraft.setCabins(cabins);
        flightPreferences.setAircraft(aircraft);
        if (fsp.isSkipConnected()) {
            FlightPreferencesType.Characteristic characteristic = new FlightPreferencesType.Characteristic();
            FlightPreferencesType.Characteristic.DirectPreferences directPreferences = new FlightPreferencesType.Characteristic.DirectPreferences();
            directPreferences.setString("Preferred");
            characteristic.setDirectPreferences(directPreferences);
            flightPreferences.setCharacteristic(characteristic);
        }
        preference.setFlightPreferences(flightPreferences);
        preferences.getPreferenceList().add(preference);
        airShoppingRQ.setPreferences(preferences);
        Collection accountCodes = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES);
        if (accountCodes != null && !accountCodes.isEmpty()) {
            if (accountCodes.size() > 1) {
                throw Xeption.forAdmin((String)("\u041d\u0435\u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u044b\u0439 account code \u0434\u043b\u044f S7 NDC: " + accountCodes), (Object[])new Object[0]);
            }
            String accountCode = (String)accountCodes.iterator().next();
            String[] accountCodeParts = accountCode.split("/");
            if (accountCodeParts.length != 2) {
                throw Xeption.forAdmin((String)("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 account code \u0434\u043b\u044f S7 NDC: " + accountCode + ", \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 QUW1234/5678"), (Object[])new Object[0]);
            }
            AirShoppingRQ.Qualifiers qualifiers = new AirShoppingRQ.Qualifiers();
            AirShoppingRQ.Qualifiers.Qualifier qualifier = new AirShoppingRQ.Qualifiers.Qualifier();
            FareQualifierType specialFareQualifiers = new FareQualifierType();
            AirlineIDType airlineID = new AirlineIDType();
            airlineID.setString("S7");
            specialFareQualifiers.setAirlineID(airlineID);
            FareQualifierType.CompanyIndex companyIndex = new FareQualifierType.CompanyIndex();
            companyIndex.setString(accountCodeParts[0]);
            specialFareQualifiers.setCompanyIndex(companyIndex);
            FareQualifierType.Account account = new FareQualifierType.Account();
            account.setString(accountCodeParts[1]);
            specialFareQualifiers.setAccount(account);
            qualifier.setSpecialFareQualifiers(specialFareQualifiers);
            qualifiers.getQualifierList().add(qualifier);
            airShoppingRQ.setQualifiers(qualifiers);
        }
        AirShopReqParamsType parameters = new AirShopReqParamsType();
        MessageParamsBaseType.CurrCodes currCodes = new MessageParamsBaseType.CurrCodes();
        CurrCode currCode = new CurrCode();
        currCode.setString(((S7NDCGdsAccount)gdsAccountCtr.getEntity()).getCurrency().getCode());
        currCodes.getCurrCodeList().add(currCode);
        parameters.setCurrCodes(currCodes);
        AirShopReqParamsType.ServiceFilters serviceFilters = new AirShopReqParamsType.ServiceFilters();
        ServiceFilterType serviceFilter = new ServiceFilterType();
        serviceFilter.setGroupCode("FareOut");
        serviceFilter.getSubGroupCodeList().add(fsp.isExcludeBaglessFares() ? "BrandedFares" : "LowFare");
        serviceFilters.getServiceFilterList().add(serviceFilter);
        serviceFilter = new ServiceFilterType();
        serviceFilter.setGroupCode("Sort");
        serviceFilter.getSubGroupCodeList().add("default");
        serviceFilters.getServiceFilterList().add(serviceFilter);
        parameters.setServiceFilters(serviceFilters);
        airShoppingRQ.setParameters(parameters);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_REQUEST_PAYLOAD, (Object)airShoppingRQ);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_ACTION, (Object)"SearchFlightsJourney");
    }
}

