/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.gds.s7ndc.S7NDCGdsAccount;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.v052.DataListsIndex;
import com.gridnine.xtrip.server.gds.s7ndc.v052.FlightConverterHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirShoppingRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightSegmentReference;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PricedFlightOfferAssocType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class AirShoppingRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        FlightSearchParameters fsp = (FlightSearchParameters)ctx.getObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        AirShoppingRS response = (AirShoppingRS)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
        DataListsIndex index = new DataListsIndex(response.getDataLists());
        List<Object> airlineOffers = new ArrayList();
        if (fsp != null && fsp.isExcludeBaglessFares()) {
            for (AirShoppingRS.AirlineOffers airlineOfferList : response.getAirlineOfferList()) {
                List<AirShoppingRS.AirlineOffers.AirlineOffer> list = airlineOfferList.getAirlineOfferList().stream().filter(airlineOffer -> this.hasBaggage((AirShoppingRS.AirlineOffers.AirlineOffer)airlineOffer, index)).collect(Collectors.toList());
                if (list.isEmpty()) continue;
                airlineOffers.add(this.getCheapestOfferWithBaggage(list));
            }
        } else {
            airlineOffers = response.getAirlineOfferList().stream().flatMap(offers -> offers.getAirlineOfferList().stream()).collect(Collectors.toList());
        }
        ArrayList<Flight> flights = new ArrayList<Flight>();
        for (AirShoppingRS.AirlineOffers.AirlineOffer airlineOffer2 : airlineOffers) {
            Flight flight;
            String accountCode = null;
            Collection accountCodes = (Collection)ctx.getObject((Enum)IBusGdsContextKeys.ACCOUNT_CODES);
            if (CollectionUtil.isNotEmpty((Collection)accountCodes)) {
                accountCode = (String)accountCodes.iterator().next();
            }
            if (FlightHelper.getSegments((Flight)(flight = FlightConverterHelper.buildFlight(accountCode, (EntityContainer<S7NDCGdsAccount>)gdsAccountCtr, response.getDataLists().getAnonymousTravelerList().getAnonymousTravelerList(), airlineOffer2.getPricedOffer().getOfferPriceList(), index, salesContext))).stream().map(FlightSegment::getAirline).noneMatch(a -> S7NDCHelper.getS7AirlineReference().equals(a))) continue;
            flight.setAncillaryFeesRequestNeeded(FlightHelper.getSegments((Flight)flight).stream().map(FlightSegment::getOperatingAirline).allMatch(a -> S7NDCHelper.getS7AirlineReference().equals(a)));
            flights.add(flight);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHTS, flights);
    }

    private boolean hasBaggage(AirShoppingRS.AirlineOffers.AirlineOffer airlineOffer, DataListsIndex index) {
        return airlineOffer.getPricedOffer().getOfferPriceList().stream().flatMap(offerPrice -> offerPrice.getRequestedDateAssociationList().stream()).map(PricedFlightOfferAssocType::getApplicableFlight).filter(Objects::nonNull).flatMap(applicableFlight -> applicableFlight.getSequence().getFlightSegmentReferenceList().stream()).map(FlightSegmentReference::getBagDetailAssociation).filter(Objects::nonNull).map(bagDetailAssociation -> bagDetailAssociation.getCheckedBagReferences().getCheckedBagReferences()).map(checkedBagRef -> index.getCheckedBagAllowance((String)checkedBagRef).getAllowanceDescription().getApplicableBag()).anyMatch(applicableBag -> !"NO".equals(applicableBag));
    }

    private AirShoppingRS.AirlineOffers.AirlineOffer getCheapestOfferWithBaggage(List<AirShoppingRS.AirlineOffers.AirlineOffer> offersWithBaggage) {
        if (offersWithBaggage.size() == 1) {
            return offersWithBaggage.get(0);
        }
        AirShoppingRS.AirlineOffers.AirlineOffer cheapestOfferWithBaggage = null;
        for (AirShoppingRS.AirlineOffers.AirlineOffer offerWithBaggage : offersWithBaggage) {
            if (cheapestOfferWithBaggage == null) {
                cheapestOfferWithBaggage = offerWithBaggage;
                continue;
            }
            if (this.getTotal(cheapestOfferWithBaggage).compareTo(this.getTotal(offerWithBaggage)) < 0) continue;
            cheapestOfferWithBaggage = offerWithBaggage;
        }
        return cheapestOfferWithBaggage;
    }

    private BigDecimal getTotal(AirShoppingRS.AirlineOffers.AirlineOffer airlineOffer) {
        return airlineOffer.getTotalPrice().getDetailCurrencyPrice().getTotal().getDecimal();
    }
}

