/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.selectFlight;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightTax;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareComponentType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ItinReshopRS;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OfferPriceLeadType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PricedFlightOfferAssocType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TaxDetailType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerInfoAssocType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerReferences;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;

public class InitReshopRSParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        ItinReshopRS response = (ItinReshopRS)ctx.getMandatoryObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_RESPONSE_PAYLOAD);
        flight.getFares().clear();
        flight.getTaxes().clear();
        HashMap<String, DictionaryReference<PassengerType>> passengerTypes = new HashMap<String, DictionaryReference<PassengerType>>();
        for (ItinReshopRS.Passenger passenger : response.getPassengerList()) {
            passengerTypes.put(passenger.getObjectKeyAttrGroup().getObjectKey(), S7NDCHelper.resolveS7NDCNativeCode(PassengerType.class, passenger.getPTC1().getString()));
        }
        for (OfferPriceLeadType offerPrice : ((ItinReshopRS.ReShopOffer)response.getResponseReShopOfferList().get(0)).getReShopPricedOffer().getOfferPriceList()) {
            String ptCode = offerPrice.getRequestedDateAssociationList().stream().filter(a -> a.getAssociatedTraveler() != null).map(PricedFlightOfferAssocType::getAssociatedTraveler).map(TravelerInfoAssocType::getTravelerReferences).map(TravelerReferences::getTravelerReferences).findAny().get();
            DictionaryReference passengerType = (DictionaryReference)passengerTypes.get(ptCode);
            BigDecimal fare = offerPrice.getRequestedDateOfferPriceLeadDetailType().getPriceDetailBaseAmount().getDecimal();
            FlightFare ff = new FlightFare();
            ff.setEquivalentAmount(fare);
            ff.setBaseAmount(MoneyHelper.buildMoney((BigDecimal)fare, (String)"RUB"));
            ff.setPassengerType(passengerType);
            flight.getFares().add(ff);
            if (offerPrice.getRequestedDateOfferPriceLeadDetailType().getPriceDetailTaxes() != null && offerPrice.getRequestedDateOfferPriceLeadDetailType().getPriceDetailTaxes().getBreakdown() != null && offerPrice.getRequestedDateOfferPriceLeadDetailType().getPriceDetailTaxes().getBreakdown().getTaxList() != null) {
                for (TaxDetailType.Breakdown.Tax tax : offerPrice.getRequestedDateOfferPriceLeadDetailType().getPriceDetailTaxes().getBreakdown().getTaxList()) {
                    FlightTax ft = new FlightTax();
                    ft.setPassengerType(passengerType);
                    ft.setEquivalentAmount(tax.getAmount().getDecimal());
                    ft.setCode(tax.getTaxCode());
                    flight.getTaxes().add(ft);
                }
            }
            Iterator fctIter = offerPrice.getFareDetail().getFareComponentList().iterator();
            for (FlightSegment fs : FlightHelper.getSegments((Flight)flight)) {
                FareComponentType fct = (FareComponentType)fctIter.next();
                fs.getFareInfos().stream().filter(fi -> passengerType.equals((Object)fi.getPassengerType())).findAny().get().setFareBasis(S7NDCHelper.buildFareBasis(fct));
            }
        }
    }
}

