/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.s7ndc.v052.selectFlight;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.util.Pair;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.IBusGdsS7NDCContextKeys;
import com.gridnine.xtrip.server.gds.s7ndc.S7NDCHelper;
import com.gridnine.xtrip.server.gds.s7ndc.SegmentWrapper;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.AirlineIDType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FareQualifierType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightItem;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.FlightType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ItinReshopRQ;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.ObjectKeyAttrGroup;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderFareDetailType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.OrderItemCoreType;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.Passenger;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.PassengerReferences;
import com.gridnine.xtrip.server.gds.s7ndc.wsmodel050.TravelerCoreType;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ItinReshopRQBuilder
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Flight flight = (Flight)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHT);
        ItinReshopRQ itinReshopRq = new ItinReshopRQ();
        ArrayList<ItinReshopRQ.Actions> listActions = new ArrayList<ItinReshopRQ.Actions>();
        ItinReshopRQ.Actions actions = new ItinReshopRQ.Actions();
        actions.setActionTypeString("Empty");
        OrderItemCoreType orderItems = new OrderItemCoreType();
        OrderItemCoreType.OrderItem orderItem = new OrderItemCoreType.OrderItem();
        FlightItem flightItem = new FlightItem();
        flightItem.setFareDetail(new OrderFareDetailType());
        List flightSegments = FlightHelper.getFlightLegs((Flight)flight).stream().flatMap(leg -> leg.stream()).collect(Collectors.toList());
        List<FlightType> originDestinationList = S7NDCHelper.initializeOriginDestinations(flightSegments, flightSeg -> new SegmentWrapper((FlightSegment)flightSeg), comp -> flightItem.getFareDetail().getFareComponentList().add(comp));
        flightItem.setOriginDestinationList(originDestinationList);
        orderItem.setFlightItem(flightItem);
        OrderItemCoreType.OrderItem.Associations associations = new OrderItemCoreType.OrderItem.Associations();
        OrderItemCoreType.OrderItem.Associations.Passengers passengers = new OrderItemCoreType.OrderItem.Associations.Passengers();
        PassengerReferences passengerReferences = new PassengerReferences();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < flight.getSeats().size(); ++i) {
            if (i + 1 != 1) {
                sb.append(" ");
            }
            sb.append("SH").append(String.valueOf(i + 1));
        }
        passengerReferences.setPassengerReferences(sb.toString());
        passengers.setPassengerReferences(passengerReferences);
        associations.setPassengers(passengers);
        orderItem.setAssociations(associations);
        orderItems.getOrderItemList().add(orderItem);
        actions.setOrderItems(orderItems);
        passengers = new ItinReshopRQ.Actions.Passengers();
        for (int i = 0; i < flight.getSeats().size(); ++i) {
            Passenger passenger = new Passenger();
            ObjectKeyAttrGroup objectKeyAttrGroup = new ObjectKeyAttrGroup();
            objectKeyAttrGroup.setObjectKey(String.join((CharSequence)"", "SH", String.valueOf(i + 1)));
            passenger.setObjectKeyAttrGroup(objectKeyAttrGroup);
            TravelerCoreType.PTC ptc1 = new TravelerCoreType.PTC();
            ptc1.setQuantity(BigInteger.ONE);
            ptc1.setString(S7NDCHelper.getS7NDCNativeCode(((SeatPreferences)flight.getSeats().get(i)).getPassengerType()));
            passenger.setPTC1(ptc1);
            passenger.setNameSurnameString("Anonymous");
            passengers.getPassengerList().add(passenger);
        }
        actions.setPassengers((ItinReshopRQ.Actions.Passengers)passengers);
        if (!StringUtils.isBlank((String)flight.getAccountCode())) {
            Pair<String> accountCodeParts = S7NDCHelper.getAccountCodeParts(flight.getAccountCode());
            ItinReshopRQ.Actions.Qualifiers qualifiers = new ItinReshopRQ.Actions.Qualifiers();
            ItinReshopRQ.Actions.Qualifiers.Qualifier qualifier = new ItinReshopRQ.Actions.Qualifiers.Qualifier();
            FareQualifierType specialFareQualifiers = new FareQualifierType();
            AirlineIDType airlineID = new AirlineIDType();
            airlineID.setString("S7");
            specialFareQualifiers.setAirlineID(airlineID);
            FareQualifierType.CompanyIndex companyIndex = new FareQualifierType.CompanyIndex();
            companyIndex.setString((String)accountCodeParts.getFirst());
            specialFareQualifiers.setCompanyIndex(companyIndex);
            FareQualifierType.Account account = new FareQualifierType.Account();
            account.setString((String)accountCodeParts.getLast());
            specialFareQualifiers.setAccount(account);
            qualifier.setSpecialFareQualifiers(specialFareQualifiers);
            qualifiers.getQualifierList().add(qualifier);
            actions.setQualifiers(qualifiers);
        }
        listActions.add(actions);
        itinReshopRq.setQueryReshopList(listActions);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_REQUEST_PAYLOAD, (Object)itinReshopRq);
        ctx.putObject((Enum)IBusGdsS7NDCContextKeys.S7NDC_WS_ACTION, (Object)"Reprice");
    }
}

